/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.extensions.OperationResponse;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ValidatingException
extends RuntimeException {
    private static final long serialVersionUID = 2402142083966257897L;
    private final OperationResponse validationReport;

    public ValidatingException(String message) {
        this(message, new OperationResponse().addError(message));
    }

    public ValidatingException(String message, OperationResponse validationReport) {
        super(message);
        this.validationReport = validationReport;
    }

    public ValidatingException(String message, Throwable cause) {
        super(message, cause);
        this.validationReport = new OperationResponse().addError(message);
    }

    public OperationResponse getValidationReport() {
        return this.validationReport;
    }

    public <R> List<R> getErrorMessages(Function<OperationResponse.OperationMessage, R> mapper) {
        return this.validationReport.getMessages().stream().filter(OperationResponse.OperationMessage::isFailureMessage).map(mapper).collect(Collectors.toList());
    }

    public <R> List<R> getWarningMessages(Function<OperationResponse.OperationMessage, R> mapper) {
        return this.validationReport.getMessages().stream().filter(OperationResponse.OperationMessage::isWarning).map(mapper).collect(Collectors.toList());
    }
}

