/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum TypeAccessMode {
    DEFAULT(true, true, true, true, "all", "public", "read/write", "read-write"),
    NONE(false, false, false, true, "none", "protected"),
    READ(true, false, false, false, "read", "read-only"),
    EDIT_ONLY(false, true, true, true, "edit-only", new String[0]),
    NO_DELETE(true, true, false, true, "no-delete", new String[0]);

    private final boolean read;
    private final boolean write;
    private final boolean delete;
    private final boolean nested;
    private final String code;
    private final String[] alternatives;

    private TypeAccessMode(boolean read, boolean write, boolean delete, boolean nested, String code, String ... alternatives) {
        this.read = read;
        this.write = write;
        this.delete = delete;
        this.nested = nested;
        this.code = code;
        this.alternatives = alternatives;
    }

    public static TypeAccessMode parse(String value) {
        if (value == null) {
            return DEFAULT;
        }
        for (TypeAccessMode typeAccessMode : TypeAccessMode.values()) {
            if (!typeAccessMode.match(value)) continue;
            return typeAccessMode;
        }
        throw new IllegalArgumentException(value + " is not a valid value " + Arrays.stream(TypeAccessMode.values()).map(Objects::toString).filter(Objects::nonNull).collect(Collectors.joining(", ", "[", "]")));
    }

    private boolean match(String value) {
        return value.equalsIgnoreCase(this.code) || value.equalsIgnoreCase(this.name()) || this.alternatives != null && Arrays.stream(this.alternatives).anyMatch(Predicate.isEqual(value.toLowerCase()));
    }

    public boolean canRead() {
        return this.read;
    }

    public boolean canWrite() {
        return this.write;
    }

    public boolean canDelete() {
        return this.delete;
    }

    public boolean canBeNested() {
        return this.nested;
    }

    public String toString() {
        return this.code;
    }
}

