/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Configs;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.models.extensions.Extensions;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.yaml.YamlParseException;
import com.ontotext.models.yaml.YamlToSomlObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SomlSchemaParser {
    private Extensions extensions = new Extensions();
    private static final Pattern ID_PATTERN = Pattern.compile("^id:\\s*?[\"']?([\\S]*?)['\"]?(?:\\s*#.*)?\\s*$", 8);

    public SomlSchema parse(String schema) {
        SomlSchema somlSchema = SomlSchemaParser.parseSchema(schema);
        SomlSchema baseSchema = this.getBaseSchema();
        baseSchema.expandSchema();
        this.appendBaseSchemaPrefixes(somlSchema, baseSchema);
        this.applySchemaExtensions(somlSchema, ExtensionPhase.FIRST);
        this.appendBaseSchema(somlSchema, baseSchema);
        this.applySchemaExtensions(somlSchema, ExtensionPhase.SECOND);
        return somlSchema;
    }

    private static SomlSchema parseSchema(String schema) {
        try {
            String input = schema.trim();
            if (input.isEmpty()) {
                return new SomlSchema();
            }
            return (SomlSchema)YamlToSomlObjectMapper.getProcessor().read(input);
        }
        catch (YamlParseException yamlExc) {
            throw new InvalidSchemaException(yamlExc.getMessage(), yamlExc);
        }
    }

    private void applySchemaExtensions(SomlSchema somlSchema, ExtensionPhase extensionPhase) {
        this.extensions.getSchemaExtensions().stream().filter(extension -> extension.canHandle(somlSchema)).forEach(extension -> extensionPhase.apply((SchemaExtension)extension, somlSchema));
    }

    public static String getId(String schema) {
        if (schema == null) {
            return null;
        }
        return StringUtils.trimToNull((String)SomlSchemaParser.getIdInternal(schema));
    }

    public static String setId(String id, String schema) {
        if (SomlSchemaParser.getIdInternal(schema) == null) {
            if (schema.contains("---")) {
                return schema.replaceFirst("---", "---\nid: " + id);
            }
            return "id: " + id + "\n" + schema;
        }
        return ID_PATTERN.matcher(schema).replaceFirst("id: " + id);
    }

    private static String getIdInternal(String schema) {
        Matcher matcher = ID_PATTERN.matcher(schema);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static SomlSchema newEmptySchema() {
        return new SomlSchemaParser().parse("");
    }

    private void appendBaseSchemaPrefixes(SomlSchema somlSchema, SomlSchema baseSchema) {
        Prefixes basePrefixes = baseSchema.getPrefixes();
        this.filterSpecialPfxIfOverridden(basePrefixes, somlSchema);
        basePrefixes.clearTrackedInformation();
        if (somlSchema.getPrefixes() != null) {
            basePrefixes.merge(somlSchema.getPrefixes());
        }
        somlSchema.setPrefixes(basePrefixes);
        Shapes baseObjects = baseSchema.getObjects();
        baseObjects.clearTrackedInformation();
        if (somlSchema.getObjects() != null) {
            baseObjects.merge(somlSchema.getObjects());
        }
        somlSchema.setObjects(baseObjects);
    }

    private void filterSpecialPfxIfOverridden(Prefixes basePrefixes, SomlSchema newSchema) {
        SpecialPrefixes specialPrefixes = newSchema.getSpecialPrefixes();
        if (specialPrefixes == null) {
            return;
        }
        basePrefixes.getVocabPrefix().ifPresent(baseVocabPrefix -> {
            Optional<String> newSchemaVocabPrefix = specialPrefixes.getVocabPrefix();
            if (newSchemaVocabPrefix.isPresent() && !baseVocabPrefix.equals(newSchemaVocabPrefix.get()) || this.isIriOverridden(basePrefixes, specialPrefixes)) {
                basePrefixes.remove(baseVocabPrefix);
            }
        });
        basePrefixes.getShapePrefix().ifPresent(baseShapePfx -> {
            Optional<String> newSchemaShapePfx = specialPrefixes.getShapePrefix();
            if (newSchemaShapePfx.isPresent() && !baseShapePfx.equals(newSchemaShapePfx.get()) || this.isIriOverridden(basePrefixes, specialPrefixes)) {
                basePrefixes.remove(baseShapePfx);
            }
        });
    }

    private boolean isIriOverridden(Prefixes basePrefixes, SpecialPrefixes specialPrefixes) {
        return specialPrefixes.getVocabIri().filter(basevociri -> !basevociri.equals(basePrefixes.getVocabPrefix().orElse(null))).isPresent();
    }

    private void appendBaseSchema(SomlSchema somlSchema, SomlSchema baseSchema) {
        baseSchema.clearTrackedInformation();
        SpecialPrefixes specialPrefixes = baseSchema.getSpecialPrefixes();
        if (somlSchema.getSpecialPrefixes() != null) {
            specialPrefixes.merge(somlSchema.getSpecialPrefixes());
        }
        somlSchema.setSpecialPrefixes(specialPrefixes);
        ScalarTypes baseScalars = baseSchema.getTypes();
        if (somlSchema.getTypes() != null) {
            baseScalars.merge(somlSchema.getTypes());
        }
        somlSchema.setTypes(baseScalars);
        Properties baseProperties = baseSchema.getProperties();
        if (baseProperties != null) {
            if (somlSchema.getProperties() != null) {
                baseProperties.merge(somlSchema.getProperties());
            }
            somlSchema.setProperties(baseProperties);
        }
        Configs baseConfig = baseSchema.getConfig();
        if (somlSchema.getConfig() != null) {
            baseConfig.merge(somlSchema.getConfig());
        }
        somlSchema.setConfig(baseConfig);
    }

    public SomlSchema getBaseSchema() {
        SomlSchema somlSchema;
        InputStreamReader reader = new InputStreamReader(this.getBaseSchemaInputStream(), StandardCharsets.UTF_8);
        try {
            somlSchema = (SomlSchema)YamlToSomlObjectMapper.getProcessor().read(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (YamlParseException yamlExc) {
                throw new InvalidSchemaException(yamlExc.getMessage(), yamlExc);
            }
            catch (IOException ioExc) {
                throw new InvalidSchemaException(ErrorMessages.get("base.model.not.found"), ioExc);
            }
        }
        ((Reader)reader).close();
        return somlSchema;
    }

    private InputStream getBaseSchemaInputStream() {
        return Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("baseSchema.yaml"));
    }

    private static enum ExtensionPhase {
        FIRST{

            @Override
            protected void apply(SchemaExtension extension, SomlSchema soml) {
                extension.preBaseSchemaMergeProcessing(soml);
            }
        }
        ,
        SECOND{

            @Override
            protected void apply(SchemaExtension extension, SomlSchema soml) {
                extension.postBaseSchemaMergeProcessing(soml);
            }
        };


        protected abstract void apply(SchemaExtension var1, SomlSchema var2);
    }
}

