/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.ShaclProperty;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.ShaclTargetNode;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class ShaclConstraintViolation {
    private Object target;
    private Object actual;
    private Object semanticObject;
    private String property;
    private ShaclConstraint constraint;
    private String node;
    private static Map<ShaclConstraint, String> errorMessagesMap = new EnumMap<ShaclConstraint, String>(ShaclConstraint.class);

    public ShaclConstraintViolation(ShaclConstraint constraint, String node, Object semanticObj, String property, Object actual) {
        if (constraint.isLengthConstraint()) {
            int length = actual.toString().length();
            this.actual = String.format("\"%s\" of length %s", actual, length);
        } else {
            this.actual = actual;
        }
        this.semanticObject = semanticObj instanceof String ? ShaclSchema.dropLeadingUnderscore((String)semanticObj) : semanticObj;
        this.property = property;
        this.constraint = constraint;
        this.node = node;
    }

    public boolean needsParsing() {
        return !(this.semanticObject instanceof String) || ((String)this.semanticObject).contains("/");
    }

    public void parseTargetValue(ShaclSchema shacl) {
        if (!this.needsParsing()) {
            String soAsString = SparqlUtil.resourceAsString((Object)this.semanticObject);
            ShaclTargetNode shaclTarget = shacl.getShaclTargetNode(soAsString);
            if (null != this.property) {
                String name = this.constraint.getLocalName();
                ShaclProperty prop = shaclTarget.getProperty(this.property, name);
                this.target = name.equals(ShaclConstraint.NODE.getLocalName()) ? prop.getTargetProp().getRange() : prop.getConstraint(name).getValue();
            } else if (shaclTarget.getPattern() != null) {
                this.target = shaclTarget.getPattern().getValue();
            }
        }
    }

    public void setSemanticObject(String semanticObject) {
        this.semanticObject = ShaclSchema.dropLeadingUnderscore(semanticObject);
    }

    public Object getSemanticObject() {
        return this.semanticObject;
    }

    public String toString() {
        String targetName;
        String semanticObjectName;
        if (this.needsParsing()) {
            semanticObjectName = "";
            targetName = "";
        } else {
            semanticObjectName = this.semanticObject.toString();
            targetName = null == this.target ? "" : this.target.toString();
        }
        return this.getErrorMessage(semanticObjectName, targetName);
    }

    private String getErrorMessage(String semanticObjectName, String targetName) {
        if (null == this.property) {
            String errorTemplate = errorMessagesMap.getOrDefault((Object)this.getConstraint(), "shacl.violation.obj.default");
            return ErrorMessages.get(errorTemplate, this.constraint.getLocalName(), this.node, semanticObjectName, targetName, this.actual);
        }
        String errorTemplate = errorMessagesMap.getOrDefault((Object)this.getConstraint(), "shacl.violation.prop.default");
        return ErrorMessages.get(errorTemplate, this.constraint.getLocalName(), this.node, semanticObjectName, this.property, targetName, this.actual);
    }

    public ShaclConstraint getConstraint() {
        return this.constraint;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getNode() {
        return this.node;
    }

    public boolean hasDuplicatesForNode(ShaclConstraintViolation other) {
        return this != other && !this.needsParsing() && this.getNode().equals(other.getNode());
    }

    static {
        errorMessagesMap.put(ShaclConstraint.MIN_COUNT, "shacl.violation.cardinality");
        errorMessagesMap.put(ShaclConstraint.MAX_COUNT, "shacl.violation.cardinality");
        errorMessagesMap.put(ShaclConstraint.UNIQUE_LANG, "shacl.violation.lang.unique");
        errorMessagesMap.put(ShaclConstraint.MAX_EXCLUSIVE, "shacl.violation.max.exclusive");
        errorMessagesMap.put(ShaclConstraint.MAX_INCLUSIVE, "shacl.violation.max.inclusive");
        errorMessagesMap.put(ShaclConstraint.MIN_EXCLUSIVE, "shacl.violation.min.exclusive");
        errorMessagesMap.put(ShaclConstraint.MIN_INCLUSIVE, "shacl.violation.min.inclusive");
        errorMessagesMap.put(ShaclConstraint.MAX_LENGTH, "shacl.violation.length");
        errorMessagesMap.put(ShaclConstraint.MIN_LENGTH, "shacl.violation.length");
        errorMessagesMap.put(ShaclConstraint.IN, "shacl.violation.value.set.exclusive");
        errorMessagesMap.put(ShaclConstraint.HAS_VALUE_IN, "shacl.violation.value.set.inclusive");
        errorMessagesMap.put(ShaclConstraint.NODE, "shacl.violation.range.object");
        errorMessagesMap = Collections.unmodifiableMap(errorMessagesMap);
    }
}

