/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.SelectableConstraints;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.subscriptions.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class Selection
implements Selectable {
    private String name;
    private String nameIri;
    private String nameShortIri;
    private String alias;
    private String responseNameIri;
    private String type;
    private boolean nonNullable;
    private boolean nonNullableElements;
    private boolean collection;
    private List<Selection> selections;
    private List<Selection> whereSelections;
    private String definedIn;
    private Arguments arguments = new Arguments();
    private Selectable parent;
    private SourceLocation location;
    private Shape definedInType;
    private List<Shape> domainConstraints;
    private boolean rangeCheck;
    private boolean requestedByUser = true;
    private boolean ignored = false;
    private boolean queryable = true;
    private SelectableConstraints constraints;
    private boolean passThrough = false;
    private String service;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameIri() {
        if (this.nameIri == null) {
            this.nameIri = Selectable.super.getNameIri();
        }
        return this.nameIri;
    }

    @Override
    public String getNameShortIri() {
        if (this.nameShortIri == null) {
            this.nameShortIri = Selectable.super.getNameShortIri();
        }
        return this.nameShortIri;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getResponseNameIri() {
        if (this.responseNameIri == null) {
            this.responseNameIri = Selectable.super.getResponseNameIri();
        }
        return this.responseNameIri;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean isNonNullable() {
        return this.nonNullable;
    }

    public void setNonNullable(boolean nonNullable) {
        this.nonNullable = nonNullable;
    }

    @Override
    public boolean isNonNullableElements() {
        return this.nonNullableElements;
    }

    public void setNonNullableElements(boolean nonNullableElements) {
        this.nonNullableElements = nonNullableElements;
    }

    @Override
    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public List<Selection> getSelections() {
        return this.selections;
    }

    public List<Selection> getWhereSelections() {
        if (this.whereSelections == null) {
            this.whereSelections = new LinkedList<Selection>();
        }
        return this.whereSelections;
    }

    public void setWhereSelections(List<Selection> selections) {
        this.whereSelections = selections;
    }

    public void setSelections(List<Selection> selections) {
        this.selections = selections;
        if (selections != null) {
            selections.forEach(selection -> selection.setParent(this));
        }
    }

    @Override
    public <R, Q extends OperationVisitorContext> R accept(OperationVisitor<R, Q> visitor, Q context) {
        return visitor.visit(this, context);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!this.queryable) {
            builder.append("-");
        }
        if (this.alias != null) {
            builder.append(this.alias).append(": ");
        }
        builder.append(this.name);
        if (this.arguments != null && !this.arguments.isEmpty()) {
            builder.append(this.arguments.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + String.valueOf(entry.getValue())).collect(Collectors.joining(", ", "(", ")")));
        }
        builder.append(" : ");
        if (this.isCollection()) {
            builder.append("[");
        }
        builder.append(this.type);
        if (this.isCollection()) {
            if (this.isNonNullableElements()) {
                builder.append("!");
            }
            builder.append("]");
        }
        if (this.isNonNullable()) {
            builder.append("!");
        }
        builder.append(" @from(").append(this.definedIn).append(") ");
        if (this.getSelections() != null && !this.getSelections().isEmpty()) {
            builder.append(" {\n");
            this.getSelections().forEach(selection -> builder.append("\t\t").append(selection).append("\n"));
            builder.append("\t}");
        }
        return builder.toString();
    }

    public void setDefinedIn(String parentType) {
        this.definedIn = parentType;
    }

    @Override
    public String getDefinedIn() {
        return this.definedIn;
    }

    @Override
    public Shape getDefinedInType() {
        return this.definedInType;
    }

    @Override
    public List<Shape> getDomainConstraints() {
        if (this.domainConstraints == null) {
            return Collections.emptyList();
        }
        return this.domainConstraints;
    }

    public void setDomainConstraints(Collection<Shape> domainConstraints) {
        if (this.domainConstraints == null) {
            this.domainConstraints = new ArrayList<Shape>();
        } else {
            this.domainConstraints.clear();
        }
        this.domainConstraints.addAll(domainConstraints);
    }

    @Override
    public Optional<PropertyShape> getProperty() {
        Shape parentShape = this.getDefinedInType();
        if (parentShape == null) {
            return Optional.empty();
        }
        if ("name".equals(this.getName())) {
            if (parentShape.getName() != null) {
                return parentShape.getProperty(parentShape.getName());
            }
            return Optional.empty();
        }
        return parentShape.getProperty(this.getNameShortIri());
    }

    @Override
    public Optional<Shape> getShapeType() {
        Shape parentShape = this.getDefinedInType();
        if (parentShape == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Shape)parentShape.getContainedIn().get(this.getType()));
    }

    public void setDefinedInType(Shape definedInType) {
        this.definedInType = definedInType;
    }

    @Override
    public boolean isComplexType() {
        return this.getSelections() != null && !this.getSelections().isEmpty();
    }

    @Override
    public Arguments getArguments() {
        return this.arguments;
    }

    public void setArguments(Arguments arguments) {
        this.arguments = arguments;
    }

    @Override
    public Selectable getParent() {
        return this.parent;
    }

    public void setParent(Selectable parent) {
        this.parent = parent;
    }

    @Override
    public SourceLocation getLocation() {
        return this.location;
    }

    public void setLocation(SourceLocation location) {
        this.location = location;
    }

    @Override
    public boolean isRangeCheck() {
        return this.rangeCheck;
    }

    @Override
    public boolean isRequestedByUser() {
        return this.requestedByUser;
    }

    public void setRequestedByUser(boolean requestedByUser) {
        this.requestedByUser = requestedByUser;
    }

    public void setRangeCheck(boolean rangeCheck) {
        this.rangeCheck = rangeCheck;
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    @Override
    public boolean isQueryable() {
        return this.queryable;
    }

    public void setAsNoneQueryable() {
        this.queryable = false;
    }

    public void setTreeAsNoneQueryable() {
        this.setAsNoneQueryable();
        this.getSelections().forEach(Selection::setTreeAsNoneQueryable);
    }

    @Override
    public boolean isPassThrough() {
        return this.passThrough;
    }

    public void setAsPassThrough() {
        this.passThrough = true;
    }

    @Override
    public SelectableConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public void setConstraints(SelectableConstraints constraints) {
        this.constraints = constraints;
    }

    @Override
    public boolean isInFragment() {
        if (this.getDefinedInType() == null) {
            return false;
        }
        SomlSchema schema = this.getDefinedInType().getContainedIn().getContainedIn();
        Prefixes prefixes = schema.getPrefixes();
        if (this.getParent() == null) {
            return false;
        }
        String parentIri = prefixes.nameToShortIri(this.getParentShapeId());
        if (parentIri == null) {
            return false;
        }
        if ("Literal".equals(parentIri)) {
            return false;
        }
        if (this.getDefinedInType().isSubClassOf("SubscriptionResponse")) {
            return false;
        }
        String definedInTypeId = this.getDefinedInType().getId();
        return !Objects.equals(parentIri, definedInTypeId) && !this.isSubClassOf(parentIri, definedInTypeId, schema);
    }

    @Nullable
    public String getParentShapeId() {
        Selectable parentSelection = this.getParent();
        if (parentSelection instanceof Subscription) {
            Shape subscriptionType = ((Subscription)parentSelection).getSubscriptionType();
            if (subscriptionType != null) {
                return subscriptionType.getId();
            }
            return null;
        }
        Prefixes prefixes = parentSelection.getDefinedInType().getContainedIn().getContainedIn().getPrefixes();
        return prefixes.nameToShortIri(parentSelection.getType());
    }

    private boolean isSubClassOf(String child, String parent, SomlSchema schema) {
        Shape shape = (Shape)schema.getObjects().get(child);
        return shape != null && shape.isSubClassOf(parent);
    }

    @Override
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Selection)) {
            return false;
        }
        Selection selection = (Selection)obj;
        return this.isNonNullable() == selection.isNonNullable() && this.isNonNullableElements() == selection.isNonNullableElements() && this.isCollection() == selection.isCollection() && this.isRangeCheck() == selection.isRangeCheck() && this.isRequestedByUser() == selection.isRequestedByUser() && Objects.equals(this.getName(), selection.getName()) && Objects.equals(this.getAlias(), selection.getAlias()) && Objects.equals(this.getType(), selection.getType()) && Objects.equals(this.getDefinedIn(), selection.getDefinedIn()) && Objects.equals(this.getArguments(), selection.getArguments()) && Objects.equals(this.getSelections(), selection.getSelections()) && Objects.equals(this.isIgnored(), selection.isIgnored());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAlias(), this.getType(), this.isNonNullable(), this.isNonNullableElements(), this.isCollection(), this.getSelections(), this.getDefinedIn(), this.getArguments(), this.isRangeCheck(), this.isRequestedByUser(), this.isIgnored());
    }

    public Selection deepCopy() {
        Selection copy = new Selection();
        copy.getArguments().putAll(this.getArguments());
        copy.setType(this.getType());
        copy.setCollection(this.isCollection());
        copy.setNonNullable(this.isNonNullable());
        copy.setNonNullableElements(this.isNonNullableElements());
        copy.setParent(this.getParent());
        copy.setDomainConstraints(this.getDomainConstraints());
        copy.setDefinedIn(this.getDefinedIn());
        copy.setDefinedInType(this.getDefinedInType());
        copy.setName(this.getName());
        copy.setAlias(this.getAlias());
        copy.setLocation(this.getLocation());
        copy.setRangeCheck(this.isRangeCheck());
        copy.setRequestedByUser(this.isRequestedByUser());
        List<Selection> selectionsCopy = this.getSelections().stream().map(Selection::deepCopy).collect(Collectors.toList());
        copy.setSelections(selectionsCopy);
        copy.whereSelections = this.getWhereSelections().stream().map(Selection::deepCopy).collect(Collectors.toList());
        copy.setIgnored(this.isIgnored());
        if (!this.isQueryable()) {
            copy.setAsNoneQueryable();
        }
        if (this.isPassThrough()) {
            copy.setAsPassThrough();
        }
        if (this.getConstraints() != null) {
            copy.setConstraints(this.getConstraints().deepCopy());
        }
        copy.setService(this.getService());
        return copy;
    }
}

