/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.google.common.collect.ImmutableSet;
import com.ontotext.models.ContainedIn;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.ScalarType;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ScalarTypes
extends LinkedHashMap<String, ScalarType>
implements TrackedModel,
YamlRepresentable,
ContainedIn<SomlSchema> {
    public static final String IRI = "iri";
    public static final String STRING = "string";
    public static final String LANG_STRING = "langString";
    public static final String STRING_OR_LANG_STRING = "stringOrLangString";
    public static final String INTEGER = "integer";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String SHORT = "short";
    public static final String BYTE = "byte";
    public static final String BOOLEAN = "boolean";
    public static final String DOUBLE = "double";
    public static final String DECIMAL = "decimal";
    public static final String FLOAT = "float";
    public static final String UNSIGNED_LONG = "unsignedLong";
    public static final String UNSIGNED_INT = "unsignedInt";
    public static final String UNSIGNED_SHORT = "unsignedShort";
    public static final String UNSIGNED_BYTE = "unsignedByte";
    public static final String POSITIVE_INTEGER = "positiveInteger";
    public static final String NON_POSITIVE_INTEGER = "nonPositiveInteger";
    public static final String NEGATIVE_INTEGER = "negativeInteger";
    public static final String NON_NEGATIVE_INTEGER = "nonNegativeInteger";
    public static final String NEGATIVE_FLOAT = "negativeFloat";
    public static final String NON_NEGATIVE_FLOAT = "nonNegativeFloat";
    public static final String POSITIVE_FLOAT = "positiveFloat";
    public static final String NON_POSITIVE_FLOAT = "nonPositiveFloat";
    public static final String YEAR = "year";
    public static final String YEAR_MONTH = "yearMonth";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String DATE_TIME = "dateTime";
    public static final String DATE_TIME_STAMP = "dateTimeStamp";
    public static final String DATE_OR_DATE_TIME = "dateOrDateTime";
    public static final String DURATION = "duration";
    public static final String DAY_TIME_DURATION = "dayTimeDuration";
    public static final String YEAR_MONTH_DURATION = "yearMonthDuration";
    public static final Set<String> NUMBER_TYPES = ImmutableSet.builder().add((Object)"integer").add((Object)"int").add((Object)"long").add((Object)"short").add((Object)"byte").add((Object)"double").add((Object)"decimal").add((Object)"float").add((Object)"unsignedLong").add((Object)"unsignedInt").add((Object)"unsignedShort").add((Object)"unsignedByte").add((Object)"positiveInteger").add((Object)"nonPositiveInteger").add((Object)"negativeInteger").add((Object)"nonNegativeInteger").add((Object)"negativeFloat").add((Object)"nonNegativeFloat").add((Object)"positiveFloat").add((Object)"nonPositiveFloat").build();
    public static final Set<String> DECIMAL_NUMBER_TYPES = ImmutableSet.builder().add((Object)"double").add((Object)"decimal").add((Object)"float").add((Object)"negativeFloat").add((Object)"nonNegativeFloat").add((Object)"positiveFloat").add((Object)"nonPositiveFloat").build();
    public static final Set<String> NONE_DECIMAL_NUMBER_TYPES = ImmutableSet.builder().add((Object)"integer").add((Object)"int").add((Object)"long").add((Object)"short").add((Object)"byte").add((Object)"unsignedLong").add((Object)"unsignedInt").add((Object)"unsignedShort").add((Object)"unsignedByte").add((Object)"positiveInteger").add((Object)"nonPositiveInteger").add((Object)"negativeInteger").add((Object)"nonNegativeInteger").build();
    public static final Set<String> TEMPORAL_TYPES = ImmutableSet.builder().add((Object)"year").add((Object)"yearMonth").add((Object)"date").add((Object)"time").add((Object)"dateTime").add((Object)"dateTimeStamp").build();
    public static final Set<String> DURATION_TYPES = ImmutableSet.builder().add((Object)"duration").add((Object)"yearMonthDuration").add((Object)"dayTimeDuration").build();
    public static final Set<String> TEXT_TYPES = ImmutableSet.builder().add((Object)"string").add((Object)"langString").add((Object)"stringOrLangString").build();
    private transient SomlSchema containedIn;
    private transient ModelTracker tracker = ModelTracker.notTracked();

    public ScalarTypes() {
        this.tracker = ModelTracker.tracked();
    }

    public ScalarTypes(boolean flag) {
    }

    public boolean isScalarType(String name) {
        return this.containsKey(name) || this.containsKey(StringUtils.uncapitalize((String)name));
    }

    public Map<String, String> toGraphQlTypeMapping() {
        return this.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ScalarType)e.getValue()).getGraphql()));
    }

    public Map<String, String> toXsdTypeMapping() {
        return this.entrySet().stream().filter(entry -> ((ScalarType)entry.getValue()).getRdf() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ScalarType)e.getValue()).getRdf()));
    }

    @Override
    public ScalarType put(String key, ScalarType value) {
        ScalarType scalarType = value;
        if (scalarType == null) {
            scalarType = new ScalarType(true);
        }
        scalarType.setName(key);
        scalarType.setContainedIn(this);
        this.tracker.trackModelEntry(key);
        return super.put(key, scalarType);
    }

    @Override
    public ScalarType putIfAbsent(String key, ScalarType value) {
        if (!this.containsKey(key)) {
            return this.put(key, value);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public ScalarType computeIfAbsent(String key, Function<? super String, ? extends ScalarType> mappingFunction) {
        if (!this.containsKey(key)) {
            return this.put(key, mappingFunction.apply(key));
        }
        return super.computeIfAbsent(key, mappingFunction);
    }

    public void merge(ScalarTypes scalars) {
        this.putAll(scalars);
        scalars.keySet().forEach(this.tracker::trackModelEntry);
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        this.values().forEach(TrackedModel::stopTracking);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        this.values().forEach(TrackedModel::clearTrackedInformation);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        this.values().forEach(TrackedModel::startTracking);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        return new YamlPrinter(configuration).addMap("types", this, this::isTracked).asString();
    }

    public void setContainedIn(SomlSchema containedIn) {
        this.containedIn = containedIn;
    }

    @Override
    public SomlSchema getContainedIn() {
        return this.containedIn;
    }

    void expand() {
        for (ScalarType scalarType : this.values()) {
            scalarType.expand();
        }
    }
}

