/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface RdfPropertyResolver {
    public String resolve(Shape var1, PropertyShape var2);

    public static Optional<String> resolveProperty(Shape shape, PropertyShape prop) {
        return RdfPropertyResolverLoader.load().stream().map(res -> res.resolve(shape, prop)).filter(Objects::nonNull).findFirst();
    }

    public static class RdfPropertyResolverLoader {
        private static final RdfPropertyResolverLoader INSTANCE = new RdfPropertyResolverLoader();
        private final List<RdfPropertyResolver> rdfPropResolvers = this.loadRdfPropResolvers();

        private RdfPropertyResolverLoader() {
        }

        static List<RdfPropertyResolver> load() {
            return RdfPropertyResolverLoader.INSTANCE.rdfPropResolvers;
        }

        private List<RdfPropertyResolver> loadRdfPropResolvers() {
            return PluginsManager.loadPlugins(RdfPropertyResolver.class);
        }
    }
}

