/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.soaas.common.StringManipulation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class Prefixes
extends LinkedHashMap<String, String>
implements TrackedModel,
Sanitizable {
    public static final String SO_NAMESPACE = "http://www.ontotext.com/semantic-object/";
    private static final Pattern RDF_PREFIX_SEPARATOR_PATTERN = Pattern.compile(":");
    private static final Set<String> FULL_NAME_PROPS = Stream.of("id", "name", "type", "value", "lang").collect(Collectors.toSet());
    private transient SomlSchema schema;
    private SpecialPrefixes specialPrefixes;
    private transient Set<String> graphqlScalarTypes;
    private transient ModelTracker tracker = ModelTracker.notTracked();
    private transient List<String> knownNamespaces;

    public Prefixes() {
        this.tracker = ModelTracker.tracked();
    }

    public Prefixes(boolean flag) {
    }

    public Optional<String> getVocabPrefix() {
        return this.specialPrefixes.getVocabPrefix();
    }

    public Optional<String> getShapePrefix() {
        return this.specialPrefixes.getShapePrefix();
    }

    public Optional<String> getBaseIri() {
        return this.specialPrefixes.getBaseIri();
    }

    public String toShortIri(String name) {
        int separatorIndex;
        if (null == name) {
            return null;
        }
        if (name.startsWith("http") && (separatorIndex = this.getSeparatorIndex(name)) > 0) {
            String namespace = name.substring(0, separatorIndex + 1);
            String localName = name.substring(separatorIndex + 1);
            Map.Entry mostConcretePrefix = this.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(namespace)).findFirst().orElseThrow(this.invalidSchema("undefined.prefix.for.namespace", namespace));
            return (String)mostConcretePrefix.getKey() + ":" + localName;
        }
        PrefixedValueSplitter splitter = PrefixedValueSplitter.split(this.getKnownNamespaces(), name);
        if (splitter.isPrefixed()) {
            return splitter.getPrefix() + ":" + splitter.getValue();
        }
        if (!splitter.isValueContainsSeparator()) {
            return this.getVocabShortPrefix() + name;
        }
        return this.entrySet().stream().filter(entry -> name.startsWith((String)entry.getValue())).max(Comparator.comparingInt(entry -> ((String)entry.getValue()).length())).map(entry -> (String)entry.getKey() + ":" + name.substring(((String)entry.getValue()).length())).orElseGet(() -> {
            if (name.contains(":")) {
                return name;
            }
            return this.getVocabShortPrefix() + name;
        });
    }

    public String toModelShortIri(String name) {
        int separatorIndex;
        if (null == name) {
            return null;
        }
        if (name.startsWith("http") && (separatorIndex = this.getSeparatorIndex(name)) > 0) {
            String namespace = name.substring(0, separatorIndex + 1);
            String localName = name.substring(separatorIndex + 1);
            Map.Entry mostConcretePrefix = this.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(namespace)).findFirst().orElseThrow(this.invalidSchema("undefined.prefix.for.namespace", namespace));
            if (this.getVocabPrefix().filter(Predicate.isEqual(mostConcretePrefix.getKey())).isPresent()) {
                return localName;
            }
            return (String)mostConcretePrefix.getKey() + ":" + localName;
        }
        PrefixedValueSplitter splitter = PrefixedValueSplitter.split(this.getKnownNamespaces(), name);
        if (splitter.isPrefixed()) {
            if (this.getVocabPrefix().filter(Predicate.isEqual(splitter.getPrefix())).isPresent()) {
                return splitter.getValue();
            }
            return splitter.getPrefix() + ":" + splitter.getValue();
        }
        if (!splitter.isValueContainsSeparator()) {
            return name;
        }
        return this.entrySet().stream().filter(entry -> name.startsWith((String)entry.getValue())).max(Comparator.comparingInt(entry -> ((String)entry.getValue()).length())).map(entry -> (String)entry.getKey() + ":" + name.substring(((String)entry.getValue()).length())).orElse(name);
    }

    public boolean irisAreEqual(String iri1, String iri2) {
        if (Objects.equals(iri1, iri2)) {
            return true;
        }
        if (iri1 == null || iri2 == null) {
            return false;
        }
        return Objects.equals(this.toIri(iri1), this.toIri(iri2));
    }

    private int getSeparatorIndex(String name) {
        int index = name.lastIndexOf(35);
        if (index > 0) {
            return index;
        }
        return name.lastIndexOf(47);
    }

    private Supplier<InvalidSchemaException> invalidSchema(String messageKey, String arg) {
        return () -> new InvalidSchemaException(ErrorMessages.get(messageKey, arg));
    }

    public String toName(String iri) {
        String shortIri = this.toShortIri(iri);
        String[] split = RDF_PREFIX_SEPARATOR_PATTERN.split(shortIri);
        if (split.length == 2) {
            if (this.specialPrefixes.getVocabPrefix().filter(vocab -> vocab.equals(split[0])).isPresent() || this.specialPrefixes.getShapePrefix().filter(shape -> shape.equals(split[0])).isPresent()) {
                if (FULL_NAME_PROPS.contains(split[1]) || this.isScalarType(split[1]) || Shapes.isSystemShapeOrInterface(split[1])) {
                    if (FULL_NAME_PROPS.contains(iri) || this.isScalarType(iri)) {
                        return iri;
                    }
                    return split[0] + "_" + split[1];
                }
                return split[1];
            }
            return split[0] + "_" + split[1];
        }
        return StringManipulation.toGraphQlModelName((String)shortIri);
    }

    private boolean isScalarType(String localName) {
        if (this.graphqlScalarTypes == null) {
            this.graphqlScalarTypes = this.schema.getTypes().values().stream().map(ScalarType::getGraphql).collect(Collectors.toSet());
        }
        return this.graphqlScalarTypes.contains(localName);
    }

    public String toIri(String name) {
        if (name.contains("/")) {
            URL url = this.toUrl(this.getBaseUrl().orElse(null), name);
            if (url != null) {
                return url.toString();
            }
            return name;
        }
        String[] prefixAndName = RDF_PREFIX_SEPARATOR_PATTERN.split(name, 2);
        if (prefixAndName.length == 1) {
            return this.specialPrefixes.getVocabIri().map(vocab -> vocab + name).orElseThrow(Prefixes.noVocabPrefix());
        }
        Object fullPrefix = this.resolvePrefixUri(prefixAndName[0]);
        return String.valueOf(fullPrefix) + prefixAndName[1];
    }

    public String toEntityId(String name) {
        if (name.contains("/")) {
            URL url = this.toUrl(this.getBaseUrl().orElse(null), name);
            if (url != null) {
                return url.toString();
            }
            return name;
        }
        String[] prefixAndName = RDF_PREFIX_SEPARATOR_PATTERN.split(name, 2);
        if (prefixAndName.length == 1) {
            return this.specialPrefixes.getBaseIri().map(base -> base + name).orElseThrow(Prefixes.noBasePrefix());
        }
        Object fullPrefix = this.resolvePrefixUri(prefixAndName[0]);
        return String.valueOf(fullPrefix) + prefixAndName[1];
    }

    private Object resolvePrefixUri(String prefix) {
        Object fullPrefix = this.get(prefix);
        if (fullPrefix == null && (fullPrefix = this.specialPrefixes.get(prefix)) == null) {
            throw this.invalidSchema("undefined.prefix", prefix).get();
        }
        return fullPrefix;
    }

    public String nameToShortIri(String name) {
        if (name == null) {
            return null;
        }
        PrefixedValueSplitter splitter = PrefixedValueSplitter.split(this.getKnownNamespaces(), name);
        if (splitter.isPrefixed()) {
            return splitter.getPrefix() + ":" + splitter.getValue();
        }
        if (splitter.isValueContainsSeparator() && (splitter = PrefixedValueSplitter.split(this.getKnownNamespaces(), StringUtils.uncapitalize((String)name))).isPrefixed()) {
            return splitter.getPrefix() + ":" + splitter.getValue();
        }
        return name;
    }

    public String toRelativeIri(String id) {
        return this.specialPrefixes.getBaseIri().map(base -> id.replace((CharSequence)base, "")).orElse(id);
    }

    private Optional<URL> getBaseUrl() {
        return this.specialPrefixes.getBaseIri().map(base -> this.toUrl(null, (String)base));
    }

    private URL toUrl(URL context, String base) {
        try {
            return new URL(context, base);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private String getVocabShortPrefix() {
        return this.getVocabPrefix().map(prefix -> prefix + ":").orElseGet(() -> this.specialPrefixes.getVocabIri().orElseThrow(Prefixes.noVocabPrefix()));
    }

    private static Supplier<InvalidSchemaException> noVocabPrefix() {
        return () -> new InvalidSchemaException(ErrorMessages.get("undefined.vocab_iri"));
    }

    private static Supplier<InvalidSchemaException> noBasePrefix() {
        return () -> new InvalidSchemaException(ErrorMessages.get("undefined.base_iri"));
    }

    public void expand(SomlSchema schema, SpecialPrefixes specialPrefixes) {
        this.specialPrefixes = specialPrefixes;
        this.schema = schema;
        this.addSpecialPrefix(specialPrefixes, specialPrefixes.getVocabPrefix().orElse(null), specialPrefixes.getVocabIri().orElse(null), "vocab_prefix");
        this.addSpecialPrefix(specialPrefixes, specialPrefixes.getShapePrefix().orElse(null), specialPrefixes.getShapeIri().orElse(null), "shape_prefix");
        this.initializeResources();
    }

    private void addSpecialPrefix(SpecialPrefixes specialPrefixes, String prefix, String iri, String somlProp) {
        if (prefix == null) {
            this.resolvePrefix(iri).ifPresent(namespace -> specialPrefixes.put(somlProp, (String)namespace));
        } else {
            Optional<String> calculatedShapePrefix = this.resolvePrefix(iri);
            if (calculatedShapePrefix.isEmpty() && null != iri) {
                this.compute(prefix, this.computeIri(somlProp, iri));
            }
        }
    }

    private BinaryOperator<String> computeIri(String somlProp, String vocabIri) {
        return (ns, iri) -> Optional.ofNullable(vocabIri).filter(newIri -> StringUtils.isBlank((CharSequence)iri) || this.irisAreEqual((String)newIri, (String)iri)).orElseThrow(() -> new InvalidSchemaException(ErrorMessages.get("vocab.iri.conflict", somlProp, String.join((CharSequence)": ", ns, iri))));
    }

    public Optional<String> resolvePrefix(String iri) {
        return this.entrySet().stream().filter(e -> ((String)e.getValue()).equals(iri)).map(Map.Entry::getKey).findFirst();
    }

    void merge(Prefixes prefixes) {
        this.putAll(prefixes);
        prefixes.keySet().forEach(this.tracker::trackModelEntry);
    }

    @Override
    public String put(String key, String value) {
        this.tracker.trackValue(key, value);
        return super.put(key, value);
    }

    @Override
    public String putIfAbsent(String key, String value) {
        this.tracker.trackModelEntry(key);
        return super.putIfAbsent(key, value);
    }

    @Override
    public String computeIfAbsent(String key, Function<? super String, ? extends String> mappingFunction) {
        this.tracker.trackModelEntry(key);
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> sanitizedNamespaces = SchemaSanitizerUtils.sanitizeMap(this, context.getOperationReport());
        sanitizedNamespaces.forEach(this.tracker::updateKey);
        context.setSanitizedPrefixNamespaces(sanitizedNamespaces);
        this.getVocabPrefix().map(SchemaSanitizerUtils::convertIfSanitizable).ifPresent(pair -> this.specialPrefixes.put("vocab_prefix", (String)pair.getRight()));
        this.initializeResources();
        context.setPrefixes(this);
    }

    private List<String> getKnownNamespaces() {
        if (this.knownNamespaces == null) {
            this.initializeResources();
        }
        return this.knownNamespaces;
    }

    private void initializeResources() {
        ArrayList<String> allNamespacesPatterns = new ArrayList<String>(this.keySet().size() * 2);
        this.keySet().forEach((? super T namespace) -> {
            allNamespacesPatterns.add(namespace + ":");
            allNamespacesPatterns.add(namespace + "_");
        });
        if (!allNamespacesPatterns.isEmpty()) {
            allNamespacesPatterns.sort(Comparator.comparing(String::length).reversed());
        }
        this.knownNamespaces = allNamespacesPatterns;
    }

    String toTurtle() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry prefixPair : this.entrySet()) {
            builder.append("@prefix ").append((String)prefixPair.getKey()).append(": <").append((String)prefixPair.getValue()).append("> .").append("\n");
        }
        return builder.toString();
    }

    public PrefixInfo resolvePrefixInfo(String value) {
        return PrefixedValueSplitter.split(this.getKnownNamespaces(), value).toInfo();
    }

    private static class PrefixedValueSplitter {
        private static final Pattern PREFIX_SEPARATORS = Pattern.compile("[_:]");
        private static final String[] INTERNAL_SUFFIXES = new String[]{"_Mutation_Response", "_Subscription"};
        private final String prefix;
        private final String value;
        private final boolean valueContainsSeparators;

        private PrefixedValueSplitter(String prefix, String value, boolean containsSeparators) {
            this.prefix = prefix;
            this.value = value;
            this.valueContainsSeparators = containsSeparators;
        }

        private static PrefixedValueSplitter split(List<String> knownNamespaces, String rawValue) {
            String value = rawValue;
            String suffix = "";
            for (String internalSuffix : INTERNAL_SUFFIXES) {
                if (!rawValue.endsWith(internalSuffix)) continue;
                value = rawValue.substring(0, rawValue.length() - internalSuffix.length());
                suffix = internalSuffix;
                break;
            }
            for (String namespace : knownNamespaces) {
                if (!value.startsWith(namespace)) continue;
                String valueWithoutPrefix = value.substring(namespace.length());
                return new PrefixedValueSplitter(PrefixedValueSplitter.trimLastChar(namespace), valueWithoutPrefix + suffix, PrefixedValueSplitter.hasSeparators(valueWithoutPrefix));
            }
            return new PrefixedValueSplitter(null, rawValue, PrefixedValueSplitter.hasSeparators(value));
        }

        private static String trimLastChar(String value) {
            return value.substring(0, value.length() - 1);
        }

        private static boolean hasSeparators(String value) {
            return StringUtils.isNotBlank((CharSequence)value) && PREFIX_SEPARATORS.matcher(value).find();
        }

        private boolean isPrefixed() {
            return this.prefix != null;
        }

        private String getPrefix() {
            return this.prefix;
        }

        private String getValue() {
            return this.value;
        }

        private boolean isValueContainsSeparator() {
            return this.valueContainsSeparators;
        }

        private PrefixInfo toInfo() {
            return new PrefixInfo(this.isPrefixed(), this.prefix, this.value);
        }
    }

    public static class PrefixInfo {
        private final boolean isPrefixed;
        private final String prefix;
        private final String value;

        private PrefixInfo(boolean isPrefixed, String prefix, String value) {
            this.isPrefixed = isPrefixed;
            this.prefix = prefix;
            this.value = value;
        }

        public boolean isPrefixed() {
            return this.isPrefixed;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getValue() {
            return this.value;
        }
    }
}

