/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraints;
import java.util.Objects;
import java.util.function.Predicate;

public class Constraint {
    public static final Constraint DUMMY = new Constraint("$internal$");
    final String shapeId;
    final ActionFilter filter;

    public Constraint(String shapeId) {
        this(shapeId, null);
    }

    public Constraint(String shapeId, ActionFilter filter) {
        this.shapeId = shapeId;
        this.filter = filter;
    }

    public String getShapeId() {
        return this.shapeId;
    }

    public ActionFilter getFilter() {
        return this.filter;
    }

    public boolean hasFiler() {
        return this.filter != null;
    }

    public String toMessage() {
        return this.toMessage(false);
    }

    public String toMessage(boolean excludeShapeId) {
        if (this.filter == null) {
            return this.shapeId;
        }
        StringBuilder builder = new StringBuilder();
        if (!excludeShapeId) {
            builder.append(this.shapeId).append(" ");
        }
        builder.append("(where: ").append(Constraints.printUserFriendlyFilter(this.filter.getFilter())).append(")");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Constraint that = (Constraint)obj;
        return Objects.equals(this.shapeId, that.shapeId) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.shapeId, this.filter);
    }

    public String toString() {
        return "{shapeId='" + this.shapeId + "', filter=" + String.valueOf(this.filter) + "}";
    }

    public static Predicate<Constraint> byShapeId(String otherId) {
        return constraint -> Objects.equals(constraint.shapeId, otherId);
    }
}

