/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.parser;

import java.io.IOException;
import java.io.Reader;
import org.semanticweb.owlapi.formats.RDFDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rdf.turtle.parser.ConsoleTripleHandler;
import org.semanticweb.owlapi.rdf.turtle.parser.OWLRDFConsumerAdapter;
import org.semanticweb.owlapi.rdf.turtle.parser.ParseException;
import org.semanticweb.owlapi.rdf.turtle.parser.TripleHandler;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParser;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParserException;

public class TurtleOntologyParser
extends AbstractOWLParser {
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new TurtleDocumentFormatFactory();
    }

    public OWLDocumentFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) {
        TurtleDocumentFormat turtleDocumentFormat;
        block8: {
            Reader r = DocumentSources.wrapInputAsReader((OWLOntologyDocumentSource)source, (OWLOntologyLoaderConfiguration)config);
            try {
                TurtleParser parser = new TurtleParser(r, (TripleHandler)new ConsoleTripleHandler(), source.getDocumentIRI());
                OWLRDFConsumerAdapter consumer = new OWLRDFConsumerAdapter(ontology, config);
                TurtleDocumentFormat format = new TurtleDocumentFormat();
                consumer.setOntologyFormat((RDFDocumentFormat)format);
                consumer.startModel(source.getDocumentIRI());
                parser.setTripleHandler(consumer);
                parser.parseDocument();
                format.copyPrefixesFrom(parser.getPrefixManager());
                turtleDocumentFormat = format;
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | OWLOntologyInputSourceException | ParseException e) {
                    throw new TurtleParserException((Throwable)e);
                }
            }
            r.close();
        }
        return turtleDocumentFormat;
    }
}

