/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.GraphMap;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.impl.RDFStarTermMapImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class RDFStarSubjectMapImpl
extends RDFStarTermMapImpl
implements SubjectMap {
    private ArrayList<IRI> classList = new ArrayList();
    private ArrayList<GraphMap> graphList = new ArrayList();

    RDFStarSubjectMapImpl(RDF c, ObjectMap subject, PredicateMap predicate, ObjectMap object) {
        super(c, subject, predicate, object);
    }

    @Override
    public void addClass(IRI classURI) {
        this.classList.add(classURI);
    }

    @Override
    public void addGraphMap(GraphMap gm) {
        this.graphList.add(gm);
    }

    @Override
    public void addGraphMap(List<GraphMap> gms) {
        this.graphList.addAll(gms);
    }

    @Override
    public IRI getClass(int index) {
        return this.classList.get(index);
    }

    @Override
    public GraphMap getGraphMap(int index) {
        return this.graphList.get(index);
    }

    @Override
    public List<IRI> getClasses() {
        return Collections.unmodifiableList(this.classList);
    }

    @Override
    public List<GraphMap> getGraphMaps() {
        return Collections.unmodifiableList(this.graphList);
    }

    @Override
    public void removeClass(IRI classURI) {
        this.classList.remove(classURI);
    }

    @Override
    public void removeGraphMap(GraphMap gm) {
        this.graphList.remove(gm);
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.addAll(super.serialize());
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#SubjectMap")));
        for (IRI cl : this.classList) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#class"), (RDFTerm)cl));
        }
        for (GraphMap g : this.graphList) {
            if (g.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graph"), g.getConstant()));
                continue;
            }
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graphMap"), (RDFTerm)g.getNode()));
            stmtSet.addAll(g.serialize());
        }
        stmtSet.addAll(this.subject.serialize());
        stmtSet.addAll(this.predicate.serialize());
        stmtSet.addAll(this.object.serialize());
        return stmtSet;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classList == null ? 0 : this.classList.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RDFStarSubjectMapImpl)) {
            return false;
        }
        RDFStarSubjectMapImpl other = (RDFStarSubjectMapImpl)obj;
        return !(this.classList == null ? other.classList != null : !this.classList.equals(other.classList) || !this.subject.equals(other.subject) || !this.predicate.equals(other.predicate) || !this.object.equals(other.object));
    }

    @Override
    public String toString() {
        return "RDFStarSubjectMapImpl [classList=" + String.valueOf(this.classList) + ", graphList=" + String.valueOf(this.graphList) + ", termMapType=" + String.valueOf((Object)this.termMapType) + ", termTypeIRI=" + String.valueOf(this.termTypeIRI) + ", node=" + String.valueOf(this.getNode()) + "subject=(" + this.subject.toString() + "), predicate=(" + this.predicate.toString() + "), object=(" + this.object.toString() + ")] ";
    }
}

