/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.GraphMap;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateMap;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.RefObjectMap;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.impl.MappingComponentImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class PredicateObjectMapImpl
extends MappingComponentImpl
implements PredicateObjectMap {
    private ArrayList<PredicateMap> predList = new ArrayList();
    private ArrayList<ObjectMap> objList = new ArrayList();
    private ArrayList<RefObjectMap> refObjList = new ArrayList();
    private ArrayList<GraphMap> graphList = new ArrayList();

    PredicateObjectMapImpl(RDF rdf, PredicateMap pm, ObjectMap om) {
        super(rdf);
        if (pm == null) {
            throw new NullPointerException("A PredicateObjectMap must have a PredicateMap.");
        }
        if (om == null) {
            throw new NullPointerException("A PredicateObjectMap must have an ObjectMap or a RefObjectMap.");
        }
        this.addPredicateMap(pm);
        this.addObjectMap(om);
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    PredicateObjectMapImpl(RDF rdf, PredicateMap pm, RefObjectMap rom) {
        super(rdf);
        if (pm == null) {
            throw new NullPointerException("A PredicateObjectMap must have at least one PredicateMap.");
        }
        if (rom == null) {
            throw new NullPointerException("A PredicateObjectMap must have an ObjectMap or a RefObjectMap.");
        }
        this.addPredicateMap(pm);
        this.addRefObjectMap(rom);
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    PredicateObjectMapImpl(RDF rdf, List<PredicateMap> pms, List<ObjectMap> oms, List<RefObjectMap> roms) {
        super(rdf);
        if (pms == null) {
            throw new NullPointerException("A PredicateObjectMap must have at least one PredicateMap.");
        }
        if (pms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one PredicateMap.");
        }
        if (oms == null && roms == null) {
            throw new NullPointerException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        if (oms == null && roms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        if (roms == null && oms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        if (oms != null && roms != null && oms.isEmpty() && roms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        for (PredicateMap pm : pms) {
            this.addPredicateMap(pm);
        }
        if (oms != null) {
            for (ObjectMap om : oms) {
                this.addObjectMap(om);
            }
        }
        if (roms != null) {
            for (RefObjectMap rom : roms) {
                this.addRefObjectMap(rom);
            }
        }
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    @Override
    public void addPredicateMap(PredicateMap pm) {
        this.predList.add(pm);
    }

    @Override
    public void addObjectMap(ObjectMap om) {
        this.objList.add(om);
    }

    @Override
    public void addRefObjectMap(RefObjectMap rom) {
        this.refObjList.add(rom);
    }

    @Override
    public void addGraphMap(GraphMap gm) {
        this.graphList.add(gm);
    }

    @Override
    public void addGraphMaps(List<GraphMap> gms) {
        this.graphList.addAll(gms);
    }

    @Override
    public GraphMap getGraphMap(int index) {
        return this.graphList.get(index);
    }

    @Override
    public RefObjectMap getRefObjectMap(int index) {
        return this.refObjList.get(index);
    }

    @Override
    public ObjectMap getObjectMap(int index) {
        return this.objList.get(index);
    }

    @Override
    public PredicateMap getPredicateMap(int index) {
        return this.predList.get(index);
    }

    @Override
    public List<GraphMap> getGraphMaps() {
        return Collections.unmodifiableList(this.graphList);
    }

    @Override
    public List<RefObjectMap> getRefObjectMaps() {
        return Collections.unmodifiableList(this.refObjList);
    }

    @Override
    public List<ObjectMap> getObjectMaps() {
        return Collections.unmodifiableList(this.objList);
    }

    @Override
    public List<PredicateMap> getPredicateMaps() {
        return Collections.unmodifiableList(this.predList);
    }

    @Override
    public void removeGraphMap(GraphMap gm) {
        this.graphList.remove(gm);
    }

    @Override
    public void removeRefObjectMap(RefObjectMap rom) {
        if (this.refObjList.size() + this.objList.size() == 1) {
            throw new IllegalStateException("Can't remove the last ObjectMap or RefObjectMap.");
        }
        this.refObjList.remove(rom);
    }

    @Override
    public void removeObjectMap(ObjectMap om) {
        if (this.objList.size() == 1) {
            throw new IllegalStateException("Can't remove the last ObjectMap or RefObjectMap.");
        }
        this.objList.remove(om);
    }

    @Override
    public void removePredicateMap(PredicateMap pm) {
        if (this.predList.size() == 1) {
            throw new IllegalStateException("Can't remove the last PredicateMap.");
        }
        this.predList.remove(pm);
    }

    @Override
    public void setNode(BlankNodeOrIRI node) {
        if (node == null) {
            throw new NullPointerException("A PredicateObjectMap must have a resource.");
        }
        this.node = node;
    }

    @Override
    public BlankNodeOrIRI getNode() {
        return this.node;
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#PredicateObjectMap")));
        for (PredicateMap pm : this.predList) {
            if (pm.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicate"), pm.getConstant()));
                continue;
            }
            stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateMap"), (RDFTerm)pm.getNode()));
            stmtSet.addAll(pm.serialize());
        }
        for (ObjectMap om : this.objList) {
            if (om.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                if (om.getTermType().equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#IRI"))) {
                    stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#object"), om.getConstant()));
                    continue;
                }
                if (!om.getTermType().equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal"))) continue;
                stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#object"), om.getConstant()));
                continue;
            }
            stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"), (RDFTerm)om.getNode()));
            stmtSet.addAll(om.serialize());
        }
        for (RefObjectMap rom : this.refObjList) {
            stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"), (RDFTerm)rom.getNode()));
            stmtSet.addAll(rom.serialize());
        }
        for (GraphMap g : this.graphList) {
            if (g.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graph"), g.getConstant()));
                continue;
            }
            stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graphMap"), (RDFTerm)g.getNode()));
            stmtSet.addAll(g.serialize());
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objList == null ? 0 : this.objList.hashCode());
        result = 31 * result + (this.predList == null ? 0 : this.predList.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredicateObjectMapImpl)) {
            return false;
        }
        PredicateObjectMapImpl other = (PredicateObjectMapImpl)obj;
        if (this.objList == null ? other.objList != null : !this.objList.equals(other.objList)) {
            return false;
        }
        if (this.predList == null ? other.predList != null : !this.predList.equals(other.predList)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }

    public String toString() {
        return "PredicateObjectMapImpl [predList=" + String.valueOf(this.predList) + ", objList=" + String.valueOf(this.objList) + ", node=" + String.valueOf(this.node) + "]";
    }
}

