/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.tasks.Task;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationTask;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;

public class ValidationTupleReaderUtil {
    private ValidationTupleReaderUtil() {
    }

    static String readId(BindingSet bindingSet, String bindingName) {
        Value idValue = bindingSet.getValue(bindingName);
        if (!(idValue instanceof IRI)) {
            throw new TupleQueryResultHandlerException(String.format("Could not find '?%s' binding value", bindingName));
        }
        String id = ((IRI)idValue).getLocalName();
        return id;
    }

    static boolean readValidationJobProperties(ValidationJob job, BindingSet bindingSet) {
        Value repository;
        Value canceledOn;
        Value completedOn;
        Value schemaId = bindingSet.getValue("schemaId");
        if (schemaId == null) {
            return false;
        }
        job.setSchemaId(Rdf4jValueConverter.convertAsString((Value)schemaId));
        Value createdOn = bindingSet.getValue("createdOn");
        if (createdOn != null) {
            job.setCreatedOn(Rdf4jValueConverter.convertAsDate((Value)createdOn));
        }
        if ((completedOn = bindingSet.getValue("completedOn")) != null) {
            job.setCompletedOn(Rdf4jValueConverter.convertAsDate((Value)completedOn));
        }
        if ((canceledOn = bindingSet.getValue("canceledOn")) != null) {
            job.setCanceledOn(Rdf4jValueConverter.convertAsDate((Value)canceledOn));
        }
        if ((repository = bindingSet.getValue("repository")) != null) {
            job.setRepository(Rdf4jValueConverter.convertAsString((Value)repository));
        }
        return true;
    }

    static void readTask(BindingSet bindingSet, Map<String, ValidationTask> tasks, Consumer<ValidationTask> onNewTask) {
        String id = ValidationTupleReaderUtil.readId(bindingSet, "taskId");
        ValidationTask task = tasks.computeIfAbsent(id, ValidationTask::new);
        boolean isNewTask = task.getValidatorName() == null;
        Value taskName = bindingSet.getValue("taskName");
        if (taskName != null) {
            Value propertyName;
            Value objectType;
            Value taskStatus;
            Value taskDuration;
            task.setValidatorName(Rdf4jValueConverter.convertAsString((Value)taskName));
            Value taskOrder = bindingSet.getValue("taskOrder");
            if (taskOrder != null) {
                task.setTaskOrder(Rdf4jValueConverter.convertAsNumber((Value)taskOrder).intValue());
            }
            if ((taskDuration = bindingSet.getValue("taskDuration")) != null) {
                task.setEvaluationDuration(Long.valueOf(Rdf4jValueConverter.convertAsNumber((Value)taskDuration).longValue()));
            }
            if ((taskStatus = bindingSet.getValue("taskStatus")) != null) {
                task.setTaskStatus((Task.TaskStatus)Rdf4jValueConverter.readEnum((Value)taskStatus, Task.TaskStatus::valueOf));
            }
            if ((objectType = bindingSet.getValue("objectType")) != null) {
                task.setObjectType(Rdf4jValueConverter.convertAsString((Value)objectType));
            }
            if ((propertyName = bindingSet.getValue("propertyName")) != null) {
                task.setPropertyName(Rdf4jValueConverter.convertAsString((Value)propertyName));
            }
            ValidationTupleReaderUtil.readTaskConfig(task, bindingSet.getValue("taskConfig"));
        } else {
            Value taskResult = bindingSet.getValue("taskResult");
            if (taskResult != null) {
                task.addResult(Rdf4jValueConverter.convertAsString((Value)taskResult));
            }
        }
        if (isNewTask) {
            onNewTask.accept(task);
        }
    }

    private static void readTaskConfig(ValidationTask task, Value taskConfigValue) {
        if (taskConfigValue == null) {
            return;
        }
        try {
            Object config = JsonUtils.fromString((String)Rdf4jValueConverter.convertAsString((Value)taskConfigValue));
            if (config instanceof Map) {
                task.setValidatorConfig((Map)config);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

