/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationTupleReaderUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;

class ValidationJobStatusTupleReader
extends AbstractTupleQueryResultHandler {
    private final Map<String, ValidationJob> jobs;

    ValidationJobStatusTupleReader() {
        this.jobs = new LinkedHashMap<String, ValidationJob>();
    }

    ValidationJobStatusTupleReader(Collection<? extends ValidationJob> jobs) {
        this.jobs = jobs.stream().collect(Collectors.toMap(ValidationJob::getJobId, Function.identity(), (v1, v2) -> v1, LinkedHashMap::new));
    }

    public void handleSolution(BindingSet bindingSet) {
        String id = ValidationTupleReaderUtil.readId(bindingSet, "jobId");
        ValidationJob job = this.jobs.computeIfAbsent(id, ValidationJob::new);
        Value statusValue = bindingSet.getValue("taskStatus");
        Value countValue = bindingSet.getValue("count");
        if (statusValue != null && countValue != null) {
            String status = Rdf4jValueConverter.convertAsString((Value)statusValue);
            int count = Rdf4jValueConverter.convertAsNumber((Value)countValue).intValue();
            switch (status) {
                case "NOT_RUN": 
                case "RUNNING": {
                    job.setRemainingTasks(job.getRemainingTasks() + count);
                    break;
                }
                case "WARN": {
                    job.setWarningTasks(job.getWarningTasks() + count);
                    break;
                }
                case "FAIL": {
                    job.setFailedTasks(job.getFailedTasks() + count);
                    break;
                }
                case "INFO": {
                    job.setInfoTasks(job.getInfoTasks() + count);
                    break;
                }
            }
            job.setTotalTasks(job.getTotalTasks() + count);
        }
    }

    public Collection<ValidationJob> getJobs() {
        return this.jobs.values();
    }
}

