/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationJobReport;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.ValidationTupleReaderUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;

class ValidationJobReportTupleReader
extends AbstractTupleQueryResultHandler {
    private Map<String, ValidationJobReport> jobs = Collections.emptyMap();
    private Map<String, ValidationTask> tasks = Collections.emptyMap();

    ValidationJobReportTupleReader() {
    }

    public void startQueryResult(List<String> bindingNames) {
        this.jobs = new LinkedHashMap<String, ValidationJobReport>();
        this.tasks = new LinkedHashMap<String, ValidationTask>();
    }

    public void handleSolution(BindingSet bindingSet) {
        String id = ValidationTupleReaderUtil.readId(bindingSet, "jobId");
        ValidationJobReport job = this.jobs.computeIfAbsent(id, ValidationJobReport::new);
        if (!ValidationTupleReaderUtil.readValidationJobProperties((ValidationJob)job, bindingSet) && bindingSet.hasBinding("taskId")) {
            ValidationTupleReaderUtil.readTask(bindingSet, this.tasks, arg_0 -> ((ValidationJobReport)job).addTask(arg_0));
        }
    }

    public Collection<ValidationJobReport> getReports() {
        return this.jobs.values();
    }
}

