/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.data;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.metamodel.storage.rdf4j.BaseRdf4jStorage;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.sparql.ArrayPropertyResultHandler;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.sparql.SinglePropertyResultHandler;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.UpdateRequest;
import com.ontotext.tasks.DataEndpointProvider;
import com.ontotext.tasks.Task;
import com.ontotext.tasks.job.JobEventNotifier;
import com.ontotext.tasks.job.JobEventType;
import com.ontotext.tasks.job.JobListener;
import com.ontotext.validator.data.SomlSchemaValidationTaskGenerator;
import com.ontotext.validator.data.ValidationConstants;
import com.ontotext.validator.data.ValidationDataRetrievalService;
import com.ontotext.validator.data.ValidationJob;
import com.ontotext.validator.data.ValidationJobReport;
import com.ontotext.validator.data.ValidationJobReportTupleReader;
import com.ontotext.validator.data.ValidationJobStatusTupleReader;
import com.ontotext.validator.data.ValidationJobTupleReader;
import com.ontotext.validator.data.ValidationManager;
import com.ontotext.validator.data.ValidationTask;
import com.ontotext.validator.data.ValidationTaskTupleReader;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdf4jValidationManager
extends BaseRdf4jStorage
implements ValidationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FIND_JOB;
    private static final String DELETE_JOB;
    private static final String LOAD_JOB_AND_TASKS;
    private static final String LOAD_JOB;
    private static final String LOAD_TASKS_FOR_PROCESSING;
    private static final String COUNT_TASKS_BY_STATUS;
    private static final String UNFINISHED_TASKS;
    private static final String RESET_UNFINISHED_TASKS;
    private final DataEndpointProvider dataEndpointProvider;
    private Function<String, SomlSchema> schemaLoader;
    private boolean disableDataLoading = false;
    private JobEventNotifier eventNotifier = new JobEventNotifier();
    private SomlSchemaValidationTaskGenerator taskGenerator = new SomlSchemaValidationTaskGenerator();
    private ValidationDataRetrievalService dataRetrievalService = new ValidationDataRetrievalService();
    private ValueFactory vf = SimpleValueFactory.getInstance();

    private static String loadQuery(String fileName, ClassLoader classLoader) throws IOException {
        return IOUtils.resourceToString((String)fileName, (Charset)StandardCharsets.UTF_8, (ClassLoader)classLoader).replaceAll("[\n\r]", " ");
    }

    public Rdf4jValidationManager(EndpointProvider endpointProvider, SparqlConnectionFactory connectionFactory, DataEndpointProvider dataEndpointProvider) {
        super(endpointProvider, connectionFactory);
        this.dataEndpointProvider = dataEndpointProvider;
    }

    public ValidationJob validate(SomlSchema schema, Set<String> types, Set<String> properties, Set<String> validations, String repository) {
        this.removeValidation(schema.getId());
        List validationTasks = types == null || types.stream().allMatch(StringUtils::isEmpty) ? this.taskGenerator.prepareForValidation(schema, properties) : this.taskGenerator.prepareForValidation(schema, types, properties);
        ValidationJobReport job = new ValidationJobReport();
        job.setCreatedOn(this.now());
        job.setSchemaId(schema.getId());
        job.setRepository(repository);
        if (validations != null && !validations.isEmpty()) {
            validationTasks.removeIf(task -> !validations.contains(task.getName()));
        }
        job.setTotalTasks(validationTasks.size());
        job.setRemainingTasks(validationTasks.size());
        job.setTasks(validationTasks);
        try {
            this.withTransaction(connection -> this.writeJob(connection, (ValidationJob)job, validationTasks));
            if (validationTasks.isEmpty()) {
                this.notifyListeners(job.getJobId(), schema.getId(), repository, JobEventType.JOB_CANCELED);
            } else {
                this.notifyListeners(job.getJobId(), schema.getId(), repository, JobEventType.NEW_JOB);
            }
            return job;
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    public boolean removeValidation(String schemaId) {
        try {
            Optional<IRI> jobId = this.findJobId(schemaId);
            if (jobId.isPresent()) {
                this.withTransaction(connection -> connection.executeUpdate((UpdateRequest)UpdateRequest.newSimpleRequest((String)String.format(DELETE_JOB, this.buildSchemaBind(schemaId))).disableRequestLogging()));
                this.notifyListeners(jobId.get().stringValue(), schemaId, null, JobEventType.JOB_REMOVED);
                return true;
            }
            return false;
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    public boolean removeValidationById(String jobId) {
        try {
            Optional<ValidationJob> validation = this.getValidationById(jobId);
            if (validation.isPresent()) {
                this.withTransaction(connection -> connection.executeUpdate((UpdateRequest)UpdateRequest.newSimpleRequest((String)String.format(DELETE_JOB, this.buildJobIdBind(jobId))).disableRequestLogging()));
                this.notifyListeners(validation.get().getJobId(), validation.get().getSchemaId(), validation.get().getRepository(), JobEventType.JOB_REMOVED);
                return true;
            }
            return false;
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    private Optional<IRI> findJobId(String schemaId) throws UnreachableStoreException {
        return Optional.ofNullable(this.withConnection(connection -> this.loadJobIri(schemaId, (SparqlConnection)connection)));
    }

    @Nullable
    private IRI loadJobIri(String schemaId, SparqlConnection connection) {
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("jobId");
        QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(FIND_JOB, this.buildSchemaBind(schemaId))).setHandler((TupleQueryResultHandler)handler).disableRequestLogging();
        connection.executeSelect(request, (TupleQueryResultHandler)handler);
        List results = handler.getResults();
        if (results.isEmpty()) {
            return null;
        }
        return (IRI)results.get(0);
    }

    public Optional<ValidationJob> cancelValidation(String schemaId) {
        return this.getValidation(schemaId).map(this::cancelValidationInternal);
    }

    public Optional<ValidationJob> cancelValidationById(String jobId) {
        return this.getValidationById(jobId).map(this::cancelValidationInternal);
    }

    @NotNull
    private ValidationJob cancelValidationInternal(ValidationJob job) {
        try {
            if (job.isActive()) {
                IRI id = this.getJobId(job);
                Date zonedDateTime = this.withTransaction(connection -> {
                    connection.removeStatements((Resource)id, ValidationConstants.CANCELED_ON, null, new Resource[]{ValidationConstants.CONTEXT});
                    Date canceledOn = this.now();
                    connection.addStatement(this.createStatement(id, ValidationConstants.CANCELED_ON, (Value)this.vf.createLiteral(canceledOn)));
                    return canceledOn;
                });
                job.setCanceledOn(zonedDateTime);
                this.notifyListeners(job.getJobId(), job.getSchemaId(), null, JobEventType.JOB_CANCELED);
            }
            return job;
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    @NotNull
    private Date now() {
        return new Date();
    }

    public Optional<ValidationJobReport> getValidationReport(String schemaId, boolean failedOnly, long limit, long offset) {
        try {
            return this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_JOB_AND_TASKS, this.buildSchemaBind(schemaId), this.buildTaskStatusFilter(failedOnly))).disableRequestLogging();
                ValidationJobReportTupleReader reader = new ValidationJobReportTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                this.fillTaskCounts(schemaId, (SparqlConnection)connection, (Collection<? extends ValidationJob>)reader.getReports());
                if (limit > 0L) {
                    this.loadOffendingValues(reader.getReports(), this.dataEndpointProvider, this.dataRetrievalService, this.schemaLoader, limit, offset);
                }
                return reader.getReports().stream().findFirst();
            });
        }
        catch (UnreachableStoreException use) {
            throw this.newCommunicationError((SomlStoreException)((Object)use));
        }
    }

    public Optional<ValidationJobReport> getValidationReportById(String jobId, boolean failedOnly, long limit, long offset) {
        try {
            return this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_JOB_AND_TASKS, this.buildJobIdBind(jobId), this.buildTaskStatusFilter(failedOnly))).disableRequestLogging();
                ValidationJobReportTupleReader reader = new ValidationJobReportTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                Optional<String> first = reader.getReports().stream().map(ValidationJob::getSchemaId).findFirst();
                if (first.isPresent()) {
                    this.fillTaskCounts(first.get(), (SparqlConnection)connection, (Collection<? extends ValidationJob>)reader.getReports());
                    if (limit > 0L) {
                        this.loadOffendingValues(reader.getReports(), this.dataEndpointProvider, this.dataRetrievalService, this.schemaLoader, limit, offset);
                    }
                    return reader.getReports().stream().findFirst();
                }
                return Optional.empty();
            });
        }
        catch (UnreachableStoreException use) {
            throw this.newCommunicationError((SomlStoreException)((Object)use));
        }
    }

    private String buildTaskStatusFilter(boolean failedOnly) {
        if (failedOnly) {
            return " ?taskId :taskStatus ?tskState. FILTER(?tskState in (\"" + String.valueOf(Task.TaskStatus.INFO) + "\", \"" + String.valueOf(Task.TaskStatus.WARN) + "\", \"" + String.valueOf(Task.TaskStatus.FAIL) + "\")). ";
        }
        return "";
    }

    private String buildTaskIdFilter(String taskId) {
        return " FILTER(?taskId = :" + taskId + "). ";
    }

    public Optional<ValidationJob> getValidation(String schemaId) {
        try {
            return this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_JOB, this.buildSchemaBind(schemaId))).disableRequestLogging();
                ValidationJobTupleReader reader = new ValidationJobTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                Collection<ValidationJob> jobs = reader.getJobs();
                ValidationJobStatusTupleReader statusTupleReader = this.fillTaskCounts(schemaId, (SparqlConnection)connection, (Collection<? extends ValidationJob>)jobs);
                return statusTupleReader.getJobs().stream().findFirst();
            });
        }
        catch (UnreachableStoreException use) {
            throw this.newCommunicationError((SomlStoreException)((Object)use));
        }
    }

    private Optional<ValidationJob> getValidationById(String jobId) {
        try {
            return this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_JOB, this.buildJobIdBind(jobId))).disableRequestLogging();
                ValidationJobTupleReader reader = new ValidationJobTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                return reader.getJobs().stream().findFirst();
            });
        }
        catch (UnreachableStoreException use) {
            throw this.newCommunicationError((SomlStoreException)((Object)use));
        }
    }

    public Optional<ValidationTask> getValidationTask(String schemaId, String taskId) {
        try {
            return this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_JOB_AND_TASKS, this.buildSchemaBind(schemaId), this.buildTaskIdFilter(taskId))).disableRequestLogging();
                ValidationJobReportTupleReader reader = new ValidationJobReportTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                return reader.getReports().stream().findFirst().flatMap(report -> report.getTasks().stream().findFirst());
            });
        }
        catch (UnreachableStoreException use) {
            throw this.newCommunicationError((SomlStoreException)((Object)use));
        }
    }

    @NotNull
    private ValidationJobStatusTupleReader fillTaskCounts(String schemaId, SparqlConnection connection, Collection<? extends ValidationJob> jobs) {
        QueryRequest countRequest = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(COUNT_TASKS_BY_STATUS, this.buildSchemaBind(schemaId))).disableRequestLogging();
        ValidationJobStatusTupleReader statusTupleReader = new ValidationJobStatusTupleReader(jobs);
        connection.executeSelect(countRequest, (TupleQueryResultHandler)statusTupleReader);
        return statusTupleReader;
    }

    public void updateJob(String schemaId, List<ValidationTask> toUpdate) {
        try {
            Optional<IRI> jobId = this.findJobId(schemaId);
            if (!jobId.isPresent()) {
                return;
            }
            ArrayList statements = new ArrayList(toUpdate.size() * 10);
            toUpdate.forEach(task -> statements.addAll(this.writeTask((ValidationTask)task)));
            this.withTransaction(connection -> {
                toUpdate.forEach(this.removeTaskData(connection));
                connection.addStatements((Iterable)statements);
                return null;
            });
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    private Consumer<ValidationTask> removeTaskData(SparqlConnection connection) {
        return task -> connection.removeStatements((Resource)this.getTaskId((ValidationTask)task), null, null, new Resource[]{ValidationConstants.CONTEXT});
    }

    public List<ValidationTask> getNextTasks(String schemaId, int numberOfTasks) {
        try {
            return this.withTransaction(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_TASKS_FOR_PROCESSING, this.buildSchemaBind(schemaId), numberOfTasks)).disableRequestLogging();
                ValidationTaskTupleReader reader = new ValidationTaskTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                Collection<ValidationTask> tasks = reader.getTasks();
                if (tasks.isEmpty()) {
                    this.markJobAsCompleted(connection, schemaId);
                } else {
                    this.setTasksAsRunning(connection, tasks);
                }
                return new ArrayList<ValidationTask>(tasks);
            });
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    private void markJobAsCompleted(SparqlConnection connection, String schemaId) {
        IRI jobIri = this.loadJobIri(schemaId, connection);
        if (jobIri != null) {
            connection.addStatement(this.createStatement(jobIri, ValidationConstants.COMPLETED_ON, (Value)this.vf.createLiteral(this.now())));
            this.notifyListeners(jobIri.stringValue(), schemaId, null, JobEventType.JOB_COMPLETED);
        }
    }

    private void setTasksAsRunning(SparqlConnection connection, Collection<ValidationTask> tasks) {
        Literal runningState = this.vf.createLiteral(Task.TaskStatus.RUNNING.toString());
        for (ValidationTask task : tasks) {
            IRI taskId = this.getTaskId(task);
            connection.removeStatements((Resource)taskId, ValidationConstants.TASK_STATUS, null, new Resource[]{ValidationConstants.CONTEXT});
            connection.addStatement(this.createStatement(taskId, ValidationConstants.TASK_STATUS, (Value)runningState));
        }
    }

    private ValidationJob writeJob(SparqlConnection connection, ValidationJob job, List<ValidationTask> tasks) {
        IRI id = this.getJobId(job);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(this.createStatement(id, RDF.TYPE, (Value)ValidationConstants.VALIDATION_TYPE));
        statements.add(this.createStatement(id, Constants.SCHEMA_ID, (Value)this.vf.createLiteral(job.getSchemaId())));
        statements.add(this.createStatement(id, ValidationConstants.CREATED_ON, (Value)this.vf.createLiteral(job.getCreatedOn())));
        if (job.getCompletedOn() != null) {
            statements.add(this.createStatement(id, ValidationConstants.COMPLETED_ON, (Value)this.vf.createLiteral(job.getCompletedOn())));
        }
        if (job.getCanceledOn() != null) {
            statements.add(this.createStatement(id, ValidationConstants.CANCELED_ON, (Value)this.vf.createLiteral(job.getCanceledOn())));
        }
        if (job.getRepository() != null) {
            statements.add(this.createStatement(id, ValidationConstants.REPOSITORY, (Value)this.vf.createLiteral(job.getRepository())));
        }
        int index = 0;
        for (ValidationTask task : tasks) {
            ++index;
            if (task.getTaskOrder() == 0) {
                task.setTaskOrder(index);
            }
            statements.add(this.createStatement(id, ValidationConstants.HAS_TASK, (Value)this.getTaskId(task)));
            statements.addAll(this.writeTask(task));
        }
        connection.addStatements(statements);
        return job;
    }

    private List<Statement> writeTask(ValidationTask task) {
        List result;
        Map config;
        IRI id = this.getTaskId(task);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(this.createStatement(id, RDF.TYPE, (Value)ValidationConstants.TASK_TYPE));
        statements.add(this.createStatement(id, ValidationConstants.NAME, (Value)this.vf.createLiteral(task.getValidatorName())));
        statements.add(this.createStatement(id, ValidationConstants.TASK_ORDER, (Value)this.vf.createLiteral(task.getTaskOrder())));
        if (task.getObjectType() != null) {
            statements.add(this.createStatement(id, ValidationConstants.OBJECT_TYPE, (Value)this.vf.createLiteral(task.getObjectType())));
        }
        if (task.getPropertyName() != null) {
            statements.add(this.createStatement(id, ValidationConstants.PROPERTY_NAME, (Value)this.vf.createLiteral(task.getPropertyName())));
        }
        statements.add(this.createStatement(id, ValidationConstants.TASK_STATUS, (Value)this.vf.createLiteral(task.getTaskStatus().toString())));
        if (task.getEvaluationDuration() != null) {
            statements.add(this.createStatement(id, ValidationConstants.TASK_DURATION, (Value)this.vf.createLiteral(task.getEvaluationDuration().longValue())));
        }
        if ((config = task.getValidatorConfig()) != null && !config.isEmpty()) {
            try {
                String configString = JsonUtils.toString((Object)config);
                statements.add(this.createStatement(id, ValidationConstants.TASK_CONFIG, (Value)this.vf.createLiteral(configString)));
            }
            catch (IOException ioe) {
                LOGGER.warn("Invalid task configuration! Not going to persist task {} configuration {}", new Object[]{task.getValidatorName(), config, ioe});
            }
        }
        if ((result = task.getResult()) != null && !result.isEmpty()) {
            for (String resultItem : result) {
                statements.add(this.createStatement(id, ValidationConstants.TASK_RESULT, (Value)this.vf.createLiteral(resultItem)));
            }
        }
        return statements;
    }

    private Statement createStatement(IRI subject, IRI predicate, Value object) {
        return this.vf.createStatement((Resource)subject, predicate, object, (Resource)ValidationConstants.CONTEXT);
    }

    private IRI getJobId(ValidationJob job) {
        String id = job.getJobId();
        if (id == null) {
            id = UUID.randomUUID().toString();
            job.setJobId(id);
        }
        return Constants.toIri(id);
    }

    private IRI getTaskId(ValidationTask task) {
        String id = task.getId();
        if (id == null) {
            id = UUID.randomUUID().toString();
            task.setId(id);
        }
        return Constants.toIri(id);
    }

    @NotNull
    private String buildSchemaBind(String schemaId) {
        return schemaId != null ? "BIND(" + this.vf.createLiteral(schemaId).toString() + " as ?schema).\n" : "";
    }

    @NotNull
    private String buildJobIdBind(String jobId) {
        IRI jobIri = null;
        if (jobId != null) {
            jobIri = !jobId.startsWith("http://www.ontotext.com/semantic-object#") && !jobId.startsWith("http") ? Constants.toIri(jobId) : this.vf.createIRI(jobId);
        }
        return jobIri != null ? "BIND(<" + String.valueOf(jobIri) + "> as ?jobId).\n" : "";
    }

    public void addJobListener(JobListener jobListener) {
        this.eventNotifier.addJobListener(jobListener);
    }

    public void removeJobListener(JobListener jobListener) {
        this.eventNotifier.removeJobListener(jobListener);
    }

    public boolean continueValidationJobs() {
        try {
            List schemaIds = this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)UNFINISHED_TASKS).disableRequestLogging();
                ArrayPropertyResultHandler handler = new ArrayPropertyResultHandler(new String[]{"jobId", "schemaId", "repository"});
                connection.executeSelect(request, (TupleQueryResultHandler)handler);
                return handler.getResults();
            });
            for (Value[] projection : schemaIds) {
                String schemaId = Rdf4jValueConverter.convertAsString((Value)projection[1]);
                String repository = null;
                if (projection[1] != null) {
                    repository = Rdf4jValueConverter.convertAsString((Value)projection[2]);
                }
                this.resumeUnfinishedTasks(schemaId);
                LOGGER.info("Resuming validation of {} at repository {}", (Object)schemaId, (Object)repository);
                String jobId = Rdf4jValueConverter.convertAsString((Value)projection[0]);
                this.notifyListeners(jobId, schemaId, repository, JobEventType.JOB_RESUMED);
            }
            return !schemaIds.isEmpty();
        }
        catch (UnreachableStoreException use) {
            throw this.newCommunicationError((SomlStoreException)((Object)use));
        }
    }

    public void setSchemaLoader(Function<String, SomlSchema> schemaLoader) {
        this.schemaLoader = schemaLoader;
    }

    public void shutdown() {
        this.dataRetrievalService.close();
    }

    public boolean isJobDone(String jobId) {
        try {
            return this.withConnection(connection -> {
                QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)String.format(LOAD_JOB, this.buildJobIdBind(jobId))).disableRequestLogging();
                ValidationJobTupleReader reader = new ValidationJobTupleReader();
                connection.executeSelect(request, (TupleQueryResultHandler)reader);
                Collection<ValidationJob> jobs = reader.getJobs();
                if (jobs.isEmpty()) {
                    return true;
                }
                ValidationJob job = jobs.stream().findFirst().orElseThrow();
                this.fillTaskCounts(job.getSchemaId(), (SparqlConnection)connection, (Collection<? extends ValidationJob>)jobs);
                return job.isDone();
            });
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    public void disableDataLoading() {
        this.disableDataLoading = true;
    }

    public boolean isDataLoadingEnabled() {
        return !this.disableDataLoading;
    }

    private void resumeUnfinishedTasks(String schemaId) {
        try {
            this.withTransaction(connection -> connection.executeUpdate((UpdateRequest)UpdateRequest.newSimpleRequest((String)String.format(RESET_UNFINISHED_TASKS, this.buildSchemaBind(schemaId))).disableRequestLogging()));
        }
        catch (SomlStoreException sse) {
            throw this.newCommunicationError(sse);
        }
    }

    @Override
    protected String getName() {
        return "rdf4j-validation-manager";
    }

    private void notifyListeners(String jobId, String schemaId, String repository, JobEventType eventType) {
        this.eventNotifier.notifyListeners(jobId, schemaId, repository, eventType);
    }

    @NotNull
    private PlatformConfigurationException newCommunicationError(SomlStoreException sse) {
        return new PlatformConfigurationException(sse.getMessage(), ErrorCode.UNHANDLED_RUNTIME);
    }

    static {
        try {
            ClassLoader classLoader = Rdf4jValidationManager.class.getClassLoader();
            FIND_JOB = Rdf4jValidationManager.loadQuery("find-job.rq", classLoader);
            DELETE_JOB = Rdf4jValidationManager.loadQuery("delete-job.rq", classLoader);
            LOAD_JOB = Rdf4jValidationManager.loadQuery("load-job-data.rq", classLoader);
            LOAD_JOB_AND_TASKS = Rdf4jValidationManager.loadQuery("load-job-with-tasks.rq", classLoader);
            COUNT_TASKS_BY_STATUS = Rdf4jValidationManager.loadQuery("count-tasks-by-status.rq", classLoader);
            LOAD_TASKS_FOR_PROCESSING = Rdf4jValidationManager.loadQuery("get-next-task-for-execution.rq", classLoader);
            UNFINISHED_TASKS = Rdf4jValidationManager.loadQuery("find-unfinished-jobs.rq", classLoader);
            RESET_UNFINISHED_TASKS = Rdf4jValidationManager.loadQuery("reset-unfinished-tasks.rq", classLoader);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

