/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.rdf4j;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.sparql.Rdf4jValueConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;

class SchemaEntityTupleReader
extends AbstractTupleQueryResultHandler {
    private Map<String, SchemaEntity> entities = Collections.emptyMap();

    SchemaEntityTupleReader() {
    }

    public void startQueryResult(List<String> bindingNames) {
        this.entities = new LinkedHashMap<String, SchemaEntity>();
    }

    public void handleSolution(BindingSet bindingSet) {
        Value endpointCreationType;
        Value errorsMsg;
        Value warningsMsg;
        Value errors;
        Value warnings;
        Value propertiesCount;
        Value objectsCount;
        Value desc;
        Value active;
        Value label;
        Value serviceAddress;
        Value timestamp;
        Value content;
        String id = this.extractEntityIdOrThrow(bindingSet);
        SchemaEntity entity = this.entities.computeIfAbsent(id, key -> new SchemaEntity());
        entity.setId(id);
        Value schemaId = bindingSet.getValue("schemaId");
        if (schemaId != null) {
            entity.setSchemaId(Rdf4jValueConverter.convert((Value)schemaId).toString());
        }
        if ((content = bindingSet.getValue("content")) != null) {
            entity.setOriginalDefinition(Rdf4jValueConverter.convert((Value)content).toString());
        }
        if ((timestamp = bindingSet.getValue("timestamp")) != null) {
            entity.setLastModified(Long.valueOf(((Number)Rdf4jValueConverter.convert((Value)timestamp)).longValue()));
        }
        if ((serviceAddress = bindingSet.getValue("serviceAddress")) != null) {
            entity.addServiceAddress(Rdf4jValueConverter.convert((Value)serviceAddress).toString());
        }
        if ((label = bindingSet.getValue("label")) != null) {
            entity.setLabel(Rdf4jValueConverter.convert((Value)label).toString());
        }
        if ((active = bindingSet.getValue("active")) != null) {
            entity.setActive((Boolean)Rdf4jValueConverter.convert((Value)active));
        }
        if ((desc = bindingSet.getValue("desc")) != null) {
            entity.setDescription(Rdf4jValueConverter.convert((Value)desc).toString());
        }
        if ((objectsCount = bindingSet.getValue("objectsCount")) instanceof Literal) {
            Literal literal = (Literal)objectsCount;
            entity.setObjectsCount(literal.intValue());
        }
        if ((propertiesCount = bindingSet.getValue("propertiesCount")) instanceof Literal) {
            Literal literal = (Literal)propertiesCount;
            entity.setPropertiesCount(literal.intValue());
        }
        if ((warnings = bindingSet.getValue("warnings")) instanceof Literal) {
            Literal literal = (Literal)warnings;
            entity.setWarnings(literal.intValue());
        }
        if ((errors = bindingSet.getValue("errors")) instanceof Literal) {
            Literal literal = (Literal)errors;
            entity.setErrors(literal.intValue());
        }
        if ((warningsMsg = bindingSet.getValue("warningsMsg")) instanceof Literal) {
            Literal literal = (Literal)warningsMsg;
            entity.setWarningsMessage(this.readJsonStringList(literal.stringValue()));
        }
        if ((errorsMsg = bindingSet.getValue("errorsMsg")) instanceof Literal) {
            Literal literal = (Literal)errorsMsg;
            entity.setErrorsMessage(this.readJsonStringList(literal.stringValue()));
        }
        if ((endpointCreationType = bindingSet.getValue("endpointCreationType")) != null) {
            entity.setEndpointCreationType(Rdf4jValueConverter.convert((Value)endpointCreationType).toString());
        }
    }

    private String extractEntityIdOrThrow(BindingSet bindingSet) {
        Value idValue = bindingSet.getValue("id");
        if (idValue instanceof IRI) {
            IRI iri = (IRI)idValue;
            return iri.getLocalName();
        }
        throw new TupleQueryResultHandlerException("Could not find '?id' binding value");
    }

    private List<String> readJsonStringList(String stringList) {
        if (StringUtils.isNotEmpty((CharSequence)stringList)) {
            try {
                Object result = JsonUtils.fromString((String)stringList);
                if (result instanceof List) {
                    return ((List)result).stream().filter(o -> {
                        String str;
                        return o instanceof String && !(str = (String)o).isEmpty();
                    }).map(o -> (String)o).toList();
                }
            }
            catch (Exception e) {
                return List.of(stringList);
            }
        }
        return null;
    }

    public Collection<SchemaEntity> getEntities() {
        return this.entities.values();
    }
}

