/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.rdf4j;

import com.github.jsonldjava.utils.JsonUtils;
import com.ontotext.metamodel.storage.SchemaBindingChanged;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SchemaEvent;
import com.ontotext.metamodel.storage.SchemaIdMismatchException;
import com.ontotext.metamodel.storage.SchemaNotificationService;
import com.ontotext.metamodel.storage.SomlAlreadyExistsException;
import com.ontotext.metamodel.storage.SomlIdManager;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlSchemaStorage;
import com.ontotext.metamodel.storage.SomlSchemaStorageUpdate;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.metamodel.storage.rdf4j.BaseRdf4jStorage;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.metamodel.storage.rdf4j.SchemaEntityTupleReader;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.sparql.AskRequest;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.Rdf4jValueConverter;
import com.ontotext.sparql.SinglePropertyResultHandler;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rdf4JSomlSchemaStore
extends BaseRdf4jStorage
implements SomlSchemaStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleValueFactory VF = SimpleValueFactory.getInstance();
    private static final String PREFIXES = "PREFIX : <http://www.ontotext.com/semantic-object#>";
    private static final String COUNT_SCHEMAS = "PREFIX : <http://www.ontotext.com/semantic-object#>SELECT (count(distinct ?schemaId) as ?count) WHERE {    GRAPH :store {        ?id :schemaId ?schemaId.        ?id :content ?content.    }}";
    private static final String QUERY_SCHEMA_DATA = "PREFIX : <http://www.ontotext.com/semantic-object#>SELECT ?id ?schemaId ?content ?timestamp ?serviceAddress ?label ?active ?desc ?objectsCount ?propertiesCount ?warnings ?errors ?warningsMsg ?errorsMsg ?endpointCreationType WHERE { GRAPH :store {%s%s ?id :schemaId ?schemaId.?id :timestamp ?timestamp.%s{} UNION {?id :service-address ?serviceAddress} OPTIONAL {?id :label ?label} OPTIONAL {?id :active ?activeVar} BIND(IF(BOUND(?activeVar), ?activeVar, true) as ?active) .  OPTIONAL {?id :description ?desc} OPTIONAL {?id :objectsCount ?objectsCount} OPTIONAL {?id :propertiesCount ?propertiesCount} OPTIONAL {?id :warnings ?warnings} OPTIONAL {?id :errors ?errors} OPTIONAL {?id :endpointCreationType ?endpointCreationType}%s %s}}";
    private static final String ASK_CONTAINS = "PREFIX : <http://www.ontotext.com/semantic-object#>ASK { GRAPH :store {%s ?id :schemaId ?schemaId.?id :content ?content.}}";
    private static final String TIME_FILTER_PATTERN = " FILTER(?timestamp > %s). ";
    private SomlSchemaStorage.SchemaExistsStrategy existsStrategy;
    private final SchemaNotificationService notificationService;
    private final SomlSchemaParser schemaParser = new SomlSchemaParser();

    public Rdf4JSomlSchemaStore(EndpointProvider endpointProvider, SparqlConnectionFactory connectionFactory, SchemaNotificationService notificationService) {
        super(endpointProvider, connectionFactory);
        this.notificationService = notificationService;
    }

    public String store(SchemaEntity entity) throws SomlStoreException {
        String schemaId = this.withConnection(connection -> {
            String currentId = entity.getSchemaId();
            if (currentId == null) {
                currentId = this.getNextId((SparqlConnection)connection);
                entity.overrideSchemaId(currentId);
            } else if (this.contains(currentId, (SparqlConnection)connection)) {
                return null;
            }
            return currentId;
        });
        if (schemaId == null) {
            this.getExistsStrategy().existsOnStore(entity);
            this.update(entity.getSchemaId(), entity);
            return entity.getSchemaId();
        }
        this.withTransaction(connection -> {
            IRI subject = this.storeSchema(schemaId, entity, connection);
            entity.setId(subject.getLocalName());
            return schemaId;
        });
        this.notifyForEvent(entity, SomlSchemaStorageUpdate.Type.INSERT);
        return schemaId;
    }

    private void notifyForEvent(SchemaEntity entity, SomlSchemaStorageUpdate.Type type) {
        this.notificationService.notifyListeners((SchemaEvent)new SomlSchemaStorageUpdate(entity.getSchemaId(), entity.getOriginalDefinition(), type));
    }

    private IRI storeSchema(String schemaId, SchemaEntity entity, SparqlConnection connection) {
        IRI subject = entity.getId() != null ? Constants.toIri(entity.getId()) : Rdf4JSomlSchemaStore.getEntityId(schemaId, connection).orElseGet(() -> Constants.toIri(UUID.randomUUID().toString()));
        connection.removeStatements((Resource)subject, Constants.CONTENT, null, new Resource[]{Constants.STORE_CONTEXT});
        connection.addStatement(VF.createStatement((Resource)subject, RDF.TYPE, (Value)Constants.SCHEMA_TYPE, (Resource)Constants.STORE_CONTEXT));
        connection.removeStatements((Resource)subject, Constants.SCHEMA_ID, null, new Resource[]{Constants.STORE_CONTEXT});
        connection.addStatement(VF.createStatement((Resource)subject, Constants.SCHEMA_ID, (Value)VF.createLiteral(entity.getSchemaId()), (Resource)Constants.STORE_CONTEXT));
        if (entity.getOriginalDefinition() != null) {
            connection.addStatement(VF.createStatement((Resource)subject, Constants.CONTENT, (Value)VF.createLiteral(entity.getOriginalDefinition()), (Resource)Constants.STORE_CONTEXT));
        }
        this.writeLastModified((Resource)subject, connection);
        if (entity.getActive() != null) {
            connection.removeStatements((Resource)subject, Constants.ACTIVE, null, new Resource[]{Constants.STORE_CONTEXT});
            connection.addStatement(VF.createStatement((Resource)subject, Constants.ACTIVE, (Value)VF.createLiteral(entity.getActive().booleanValue()), (Resource)Constants.STORE_CONTEXT));
        }
        connection.removeStatements((Resource)subject, Constants.LABEL, null, new Resource[]{Constants.STORE_CONTEXT});
        if (StringUtils.isNotEmpty((CharSequence)entity.getLabel())) {
            connection.addStatement(VF.createStatement((Resource)subject, Constants.LABEL, (Value)VF.createLiteral(entity.getLabel()), (Resource)Constants.STORE_CONTEXT));
        }
        connection.removeStatements((Resource)subject, Constants.DESCRIPTION, null, new Resource[]{Constants.STORE_CONTEXT});
        if (StringUtils.isNotEmpty((CharSequence)entity.getDescription())) {
            connection.addStatement(VF.createStatement((Resource)subject, Constants.DESCRIPTION, (Value)VF.createLiteral(entity.getDescription()), (Resource)Constants.STORE_CONTEXT));
        }
        connection.removeStatements((Resource)subject, Constants.OBJECTS_COUNT, null, new Resource[]{Constants.STORE_CONTEXT});
        connection.addStatement(VF.createStatement((Resource)subject, Constants.OBJECTS_COUNT, (Value)VF.createLiteral(entity.getObjectsCount()), (Resource)Constants.STORE_CONTEXT));
        connection.removeStatements((Resource)subject, Constants.PROPERTIES_COUNT, null, new Resource[]{Constants.STORE_CONTEXT});
        connection.addStatement(VF.createStatement((Resource)subject, Constants.PROPERTIES_COUNT, (Value)VF.createLiteral(entity.getPropertiesCount()), (Resource)Constants.STORE_CONTEXT));
        connection.removeStatements((Resource)subject, Constants.WARNINGS, null, new Resource[]{Constants.STORE_CONTEXT});
        connection.addStatement(VF.createStatement((Resource)subject, Constants.WARNINGS, (Value)VF.createLiteral(entity.getWarnings()), (Resource)Constants.STORE_CONTEXT));
        connection.removeStatements((Resource)subject, Constants.ERRORS, null, new Resource[]{Constants.STORE_CONTEXT});
        connection.addStatement(VF.createStatement((Resource)subject, Constants.ERRORS, (Value)VF.createLiteral(entity.getErrors()), (Resource)Constants.STORE_CONTEXT));
        connection.removeStatements((Resource)subject, Constants.WARNINGS_MESSAGE, null, new Resource[]{Constants.STORE_CONTEXT});
        this.writeListAsJsonString(entity.getWarningsMessage()).map(arg_0 -> ((SimpleValueFactory)VF).createLiteral(arg_0)).map(messages -> VF.createStatement((Resource)subject, Constants.WARNINGS_MESSAGE, (Value)messages, (Resource)Constants.STORE_CONTEXT)).ifPresent(arg_0 -> ((SparqlConnection)connection).addStatement(arg_0));
        connection.removeStatements((Resource)subject, Constants.ERRORS_MESSAGE, null, new Resource[]{Constants.STORE_CONTEXT});
        this.writeListAsJsonString(entity.getErrorsMessage()).map(arg_0 -> ((SimpleValueFactory)VF).createLiteral(arg_0)).map(messages -> VF.createStatement((Resource)subject, Constants.ERRORS_MESSAGE, (Value)messages, (Resource)Constants.STORE_CONTEXT)).ifPresent(arg_0 -> ((SparqlConnection)connection).addStatement(arg_0));
        if (StringUtils.isNotEmpty((CharSequence)entity.getEndpointCreationType())) {
            connection.removeStatements((Resource)subject, Constants.ENDPOINT_CREATION_TYPE, null, new Resource[]{Constants.STORE_CONTEXT});
            connection.addStatement(VF.createStatement((Resource)subject, Constants.ENDPOINT_CREATION_TYPE, (Value)VF.createLiteral(entity.getEndpointCreationType().toLowerCase()), (Resource)Constants.STORE_CONTEXT));
        }
        return subject;
    }

    static Optional<IRI> getEntityId(String schemaId, SparqlConnection connection) {
        return Rdf4JSomlSchemaStore.getEntityId(schemaId, false, connection);
    }

    static Optional<IRI> getEntityId(String schemaId, boolean includeDeleted, SparqlConnection connection) {
        QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)("PREFIX : <http://www.ontotext.com/semantic-object#>SELECT ?id where {GRAPH :store {" + Rdf4JSomlSchemaStore.buildSchemaBind(schemaId) + (includeDeleted ? "" : "?id :content ?content. ") + "?id :schemaId ?schemaId.} }")).disableRequestLogging();
        SinglePropertyResultHandler handler = new SinglePropertyResultHandler("id");
        connection.executeSelect(request, (TupleQueryResultHandler)handler);
        return handler.getResults().stream().filter(IRI.class::isInstance).map(IRI.class::cast).findFirst();
    }

    public boolean contains(String id) throws UnreachableStoreException {
        return this.withConnection(connection -> this.contains(id, (SparqlConnection)connection));
    }

    private boolean contains(String id, SparqlConnection connection) {
        AskRequest question = (AskRequest)AskRequest.newSimpleQuery((String)String.format(ASK_CONTAINS, Rdf4JSomlSchemaStore.buildSchemaBind(id))).disableRequestLogging();
        return connection.executeAsk(question).isYes();
    }

    private String getNextId(SparqlConnection connection) {
        String offer;
        while (this.contains(offer = SomlIdManager.INSTANCE.generateSomlId(), connection)) {
        }
        return offer;
    }

    public String update(String id, SchemaEntity entity) throws SomlStoreException {
        String oldDocument = this.get(id).orElse(null);
        if (oldDocument == null) {
            this.getExistsStrategy().notExistsOnUpdate(id, entity);
            this.store(entity);
            return entity.getOriginalDefinition();
        }
        String somlId = entity.getSchemaId();
        if (somlId == null) {
            entity.overrideSchemaId(id);
        } else if (!somlId.equals(id)) {
            if ("/soml/soml-rbac".equals(id)) {
                throw new SchemaIdMismatchException(String.format("Mismatch between url-id '%s' and in-schema id '%s'", id, somlId));
            }
            if (this.get(entity.getSchemaId()).isPresent()) {
                throw new SomlAlreadyExistsException("Cannot update schema with id '" + id + "' because the new schemaId '" + somlId + "' already exists in another schema. Schema IDs must be unique.");
            }
            LOGGER.warn("Mismatch between url-id '{}' and in-schema id '{}'", (Object)id, (Object)somlId);
        }
        this.withTransaction(connection -> {
            this.storeSchema(id, entity, connection);
            return null;
        });
        if (!Objects.equals(oldDocument, entity.getOriginalDefinition())) {
            this.notifyForEvent(entity, SomlSchemaStorageUpdate.Type.UPDATE);
        }
        return oldDocument;
    }

    private Optional<String> find(String id, SparqlConnection connection) {
        return this.search(id, null, 0, 0, false, true, connection).stream().map(SchemaEntity::getOriginalDefinition).findFirst();
    }

    public Optional<String> get(String id) throws UnreachableStoreException {
        return this.withConnection(connection -> this.find(id, (SparqlConnection)connection));
    }

    public Optional<SchemaEntity> getEntity(String id) throws UnreachableStoreException {
        return this.withConnection(connection -> this.search(id, null, 0, 0, false, true, (SparqlConnection)connection).stream().findFirst());
    }

    public Optional<SomlSchema> getParsed(String id) throws UnreachableStoreException {
        return this.get(id).map(arg_0 -> ((SomlSchemaParser)this.schemaParser).parse(arg_0));
    }

    public Collection<SchemaEntity> getAll(int skip, int limit, Date modifiedAfter, boolean includeDeleted, boolean includeInactive) throws UnreachableStoreException {
        return this.search(modifiedAfter, skip, limit, includeDeleted, includeInactive);
    }

    private static QueryRequest buildPagedQueryRequest(String schemaId, Date lastModified, int skip, int limit, boolean includeDeleted, boolean includeInactive) {
        Object query = String.format(QUERY_SCHEMA_DATA, Rdf4JSomlSchemaStore.buildSchemaBind(schemaId), Rdf4JSomlSchemaStore.buildContentSelection(includeDeleted), Rdf4JSomlSchemaStore.buildTimeFilter(lastModified), Rdf4JSomlSchemaStore.buildMessagesOptional(schemaId != null), Rdf4JSomlSchemaStore.filterActiveOnly(includeInactive));
        if (limit > 0) {
            query = (String)query + " LIMIT " + limit;
        }
        if (skip > 0) {
            query = (String)query + " OFFSET " + skip;
        }
        return (QueryRequest)QueryRequest.newSimpleQuery((String)query).disableRequestLogging();
    }

    private static String filterActiveOnly(boolean includeInactive) {
        if (includeInactive) {
            return "";
        }
        return "FILTER(?active).";
    }

    private static String buildContentSelection(boolean includeDeleted) {
        if (includeDeleted) {
            return "OPTIONAL { ?id :content ?content. }";
        }
        return "?id :content ?content.";
    }

    @NotNull
    private static String buildTimeFilter(Date lastModified) {
        return lastModified != null ? String.format(TIME_FILTER_PATTERN, VF.createLiteral(lastModified.getTime()).toString()) : "";
    }

    @NotNull
    private static String buildSchemaBind(String schemaId) {
        return schemaId != null ? "BIND(" + VF.createLiteral(schemaId).toString() + " as ?schemaId)." : "";
    }

    private static String buildMessagesOptional(boolean includeMsgOptional) {
        return includeMsgOptional ? " OPTIONAL {?id :warningsMessage ?warningsMsg} OPTIONAL {?id :errorsMessage ?errorsMsg}" : "";
    }

    private Collection<SchemaEntity> search(Date lastModified, int skip, int limit, boolean includeDeleted, boolean includeInactive) throws UnreachableStoreException {
        return this.withConnection(connection -> this.search(null, lastModified, skip, limit, includeDeleted, includeInactive, (SparqlConnection)connection));
    }

    private Collection<SchemaEntity> search(String schemaId, Date lastModified, int skip, int limit, boolean includeDeleted, boolean includeInactive, SparqlConnection connection) {
        QueryRequest request = Rdf4JSomlSchemaStore.buildPagedQueryRequest(schemaId, lastModified, skip, limit, includeDeleted, includeInactive);
        SchemaEntityTupleReader handler = new SchemaEntityTupleReader();
        connection.executeSelect(request, (TupleQueryResultHandler)handler);
        return handler.getEntities();
    }

    public boolean remove(String id) throws UnreachableStoreException {
        return this.removeEntity(id, connection -> {
            IRI entityId = Rdf4JSomlSchemaStore.getEntityId(id, connection).orElse(null);
            if (entityId != null) {
                connection.removeStatements((Resource)entityId, Constants.CONTENT, null, new Resource[]{Constants.STORE_CONTEXT});
                this.writeLastModified((Resource)entityId, connection);
                return true;
            }
            return false;
        });
    }

    public boolean delete(String id) throws UnreachableStoreException {
        return this.removeEntity(id, connection -> {
            IRI entityId = Rdf4JSomlSchemaStore.getEntityId(id, true, connection).orElse(null);
            if (entityId == null) {
                return false;
            }
            connection.removeStatements((Resource)entityId, null, null, new Resource[]{Constants.STORE_CONTEXT});
            return true;
        });
    }

    private boolean removeEntity(String id, BaseRdf4jStorage.FunctionWithException<Boolean, SomlStoreException> connectionConsumer) throws UnreachableStoreException {
        try {
            Boolean deleted = this.withTransaction(connectionConsumer);
            if (Boolean.TRUE.equals(deleted)) {
                SchemaEntity entity = new SchemaEntity();
                entity.setSchemaId(id);
                this.notifyForEvent(entity, SomlSchemaStorageUpdate.Type.DELETE);
            }
            return deleted;
        }
        catch (UnreachableStoreException use) {
            throw use;
        }
        catch (SomlStoreException sse) {
            return false;
        }
    }

    public long clear() throws UnreachableStoreException {
        int size = this.size();
        try {
            this.withTransaction(connection -> {
                connection.dropGraphs(Collections.singletonList(Constants.STORE_CONTEXT.toString()));
                return null;
            });
        }
        catch (SomlStoreException sse) {
            throw new IllegalStateException(sse);
        }
        return size;
    }

    public int size() throws UnreachableStoreException {
        return this.withConnection(connection -> {
            QueryRequest request = (QueryRequest)QueryRequest.newSimpleQuery((String)COUNT_SCHEMAS).disableRequestLogging();
            SinglePropertyResultHandler handler = new SinglePropertyResultHandler("count");
            connection.executeSelect(request, (TupleQueryResultHandler)handler);
            return handler.getResults().stream().map(Rdf4jValueConverter::convert).map(Number.class::cast).mapToInt(Number::intValue).findFirst().orElse(0);
        });
    }

    public void registerListener(Consumer<SomlSchemaStorageUpdate> consumer) {
        this.notificationService.registerListener(consumer);
    }

    public void registerBindListener(Consumer<SchemaBindingChanged> consumer) {
        this.notificationService.registerBindListener(consumer);
    }

    public void unregisterListener(Consumer<SomlSchemaStorageUpdate> consumer) {
        this.notificationService.unregisterListener(consumer);
    }

    public void unregisterBindListener(Consumer<SchemaBindingChanged> consumer) {
        this.notificationService.unregisterBindListener(consumer);
    }

    public void registerSchemaService(String id, String serviceHostname) throws UnreachableStoreException {
        try {
            this.withTransaction(connection -> {
                IRI entityId = Rdf4JSomlSchemaStore.getEntityId(id, connection).orElse(null);
                if (entityId != null) {
                    connection.addStatement(VF.createStatement((Resource)entityId, Constants.SERVICE_ADDRESS, (Value)VF.createIRI(this.ensureValidIri(serviceHostname)), (Resource)Constants.STORE_CONTEXT));
                    this.writeLastModified((Resource)entityId, connection);
                    LOGGER.info("Registered schema {} at service {}", (Object)id, (Object)serviceHostname);
                } else {
                    LOGGER.warn("Could not find schema: {}. Service registration skipped.", (Object)id);
                }
                return null;
            });
        }
        catch (UnreachableStoreException use) {
            throw use;
        }
        catch (SomlStoreException sse) {
            LOGGER.warn("Could not register service.", (Throwable)sse);
        }
    }

    private String ensureValidIri(String serviceHostname) {
        if (serviceHostname.contains("://")) {
            return serviceHostname;
        }
        return "http://" + serviceHostname;
    }

    public void deregisterSchemaService(String id, String serviceHostname) throws UnreachableStoreException {
        List<IRI> ids = this.withConnection(connection -> this.search(id, null, 0, 0, false, false, (SparqlConnection)connection)).stream().filter(entity -> entity.getServiceAddresses().contains(serviceHostname)).map(SchemaEntity::getId).map(Constants::toIri).toList();
        if (ids.isEmpty()) {
            LOGGER.warn("Could not find registration for schema: {}. Service deregistration skipped.", (Object)id);
            return;
        }
        try {
            this.withTransaction(connection -> {
                for (IRI iri : ids) {
                    connection.removeStatements((Resource)iri, Constants.SERVICE_ADDRESS, (Value)VF.createIRI(serviceHostname), new Resource[]{Constants.STORE_CONTEXT});
                    this.writeLastModified((Resource)iri, connection);
                }
                LOGGER.info("Unregistered schema {} from service {}", (Object)id, (Object)serviceHostname);
                return null;
            });
        }
        catch (SomlStoreException sse) {
            LOGGER.warn("Could not deregister service: {}", (Object)serviceHostname, (Object)sse);
        }
    }

    public List<String> getRegisteredSchemaServices(String id) throws UnreachableStoreException, SomlNotFoundException {
        IRI entityId = (IRI)this.withConnection(connection -> Rdf4JSomlSchemaStore.getEntityId(id, connection)).orElseThrow(() -> new SomlNotFoundException("SOML schema is not present in the store: " + id));
        return this.withConnection(connection -> connection.stream((Resource)entityId, Constants.SERVICE_ADDRESS, null, new Resource[]{Constants.STORE_CONTEXT}).map(Statement::getObject).map(Rdf4jValueConverter::convert).map(Object::toString).toList());
    }

    public void setSchemaExistsStrategy(SomlSchemaStorage.SchemaExistsStrategy existsStrategy) {
        this.existsStrategy = existsStrategy;
    }

    public SomlSchemaStorage.SchemaExistsStrategy getSchemaExistsStrategy() {
        return this.existsStrategy;
    }

    private SomlSchemaStorage.SchemaExistsStrategy getExistsStrategy() {
        if (this.existsStrategy == null) {
            this.existsStrategy = new SomlSchemaStorage.DefaultSchemaExistsStrategy();
        }
        return this.existsStrategy;
    }

    @Override
    protected String getName() {
        return "rdf4j-schema-store";
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.notificationService.stop();
        }
    }

    private Optional<String> writeListAsJsonString(List<String> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            try {
                return Optional.of(JsonUtils.toString(list));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

