/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.metamodel.storage.rdf4j;

import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.metamodel.storage.rdf4j.Constants;
import com.ontotext.soaas.common.HealthCheckable;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import java.io.Closeable;
import java.util.function.Function;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public abstract class BaseRdf4jStorage
implements HealthCheckable,
Closeable {
    protected final EndpointProvider endpointProvider;
    protected final SparqlConnectionFactory connectionFactory;
    protected final SparqlEndpoint endpoint;

    protected BaseRdf4jStorage(EndpointProvider endpointProvider, SparqlConnectionFactory connectionFactory) {
        this.endpointProvider = endpointProvider;
        this.connectionFactory = connectionFactory;
        this.endpoint = (SparqlEndpoint)endpointProvider.getEndpoint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <E> E withTransaction(FunctionWithException<E, SomlStoreException> connectionConsumer) throws SomlStoreException {
        try (SparqlConnection connection = this.connectionFactory.getConnection(this.endpoint);){
            E e = this.executeInTx(connectionConsumer, connection);
            return e;
        }
        catch (RDF4JException re) {
            return this.throwCommunicationError((Exception)((Object)re));
        }
    }

    private <E> E executeInTx(FunctionWithException<E, SomlStoreException> connectionConsumer, SparqlConnection connection) throws SomlStoreException {
        connection.begin();
        boolean txFailed = false;
        try {
            E result = connectionConsumer.apply(connection);
            connection.commit();
            E e = result;
            return e;
        }
        catch (SomlStoreException | RuntimeException re) {
            txFailed = true;
            throw re;
        }
        finally {
            if (txFailed) {
                connection.rollback();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <E> E withConnection(Function<SparqlConnection, E> connectionConsumer) throws UnreachableStoreException {
        try (SparqlConnection connection = this.connectionFactory.getConnection(this.endpoint);){
            E e = connectionConsumer.apply(connection);
            return e;
        }
        catch (RDF4JException re) {
            return this.throwCommunicationError((Exception)((Object)re));
        }
    }

    private <E> E throwCommunicationError(Exception re) throws UnreachableStoreException {
        if (re instanceof UnauthorizedException || re.getCause() instanceof UnauthorizedException) {
            throw UnreachableStoreException.unauthorized();
        }
        Throwable cause = re.getCause();
        if (cause == null) {
            throw UnreachableStoreException.communicationError((Throwable)re);
        }
        throw UnreachableStoreException.communicationError((Throwable)cause);
    }

    protected void writeLastModified(Resource subject, SparqlConnection connection) {
        connection.removeStatements(subject, Constants.TIMESTAMP, null, new Resource[]{Constants.STORE_CONTEXT});
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        connection.addStatement(vf.createStatement(subject, Constants.TIMESTAMP, (Value)vf.createLiteral(System.currentTimeMillis()), (Resource)Constants.STORE_CONTEXT));
    }

    public HealthResult runHealthCheck() {
        return this.connectionFactory.checkHealth((SparqlEndpoint)this.endpointProvider.getHealthEndpoint());
    }

    @Override
    public void close() {
        this.connectionFactory.close();
    }

    protected abstract String getName();

    @FunctionalInterface
    public static interface FunctionWithException<E, X extends Exception> {
        public E apply(SparqlConnection var1) throws X;
    }
}

