/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.BaseExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.SimpleExecution;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class SimpleRequest
extends BaseExecutionRequest<SimpleExecution> {
    private List<SimpleExecution> executions = new LinkedList<SimpleExecution>();
    @Nullable
    private Boolean includeInferred;
    @Nullable
    private Boolean expandSameAs;

    public SimpleRequest() {
        super(null, null);
    }

    @Override
    public void addExecution(SimpleExecution execution) {
        execution.setSilent(this.isSilent());
        execution.setTxId((String)ObjectUtils.getIfNull((Object)execution.getTxId(), this::getTxId));
        this.executions.add(execution);
    }

    @Override
    public List<SimpleExecution> getExecutions() {
        return this.executions;
    }

    @Override
    public ExecutionRequest<SimpleExecution> createCopyFor(List<SimpleExecution> executions) {
        SimpleRequest executionContext = new SimpleRequest();
        executionContext.executions.addAll(executions);
        executionContext.setSilent(this.isSilent());
        executionContext.setIncludeInferred(this.getIncludeInferred());
        executionContext.setExpandSameAs(this.getExpandSameAs());
        return executionContext;
    }

    @Override
    public void setSilent(boolean silent) {
        super.setSilent(silent);
        this.executions.forEach(simpleExecution -> simpleExecution.setSilent(silent));
    }

    @Nullable
    public Boolean getIncludeInferred() {
        return this.includeInferred;
    }

    public SimpleRequest setIncludeInferred(@Nullable Boolean includeInferred) {
        this.includeInferred = includeInferred;
        this.executions.forEach(simpleExecution -> simpleExecution.setIncludeInferred(includeInferred));
        return this;
    }

    @Nullable
    public Boolean getExpandSameAs() {
        return this.expandSameAs;
    }

    public SimpleRequest setExpandSameAs(@Nullable Boolean expandSameAs) {
        this.expandSameAs = expandSameAs;
        this.executions.forEach(simpleExecution -> simpleExecution.setExpandSameAs(expandSameAs));
        return this;
    }
}

