/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.concurrent.Node;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.sparql.PreviousExecution;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.SparqlRequestBuilder;
import com.ontotext.sparql.SparqlResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class QueryStep
implements Node<QueryStep>,
SparqlRequestBuilder<String> {
    private final String id;
    private final QueryStep parentStep;
    private final Function<RdfTree, String> queryBuilder;
    private final Supplier<Map<String, List<String>>> bindingsProvider;
    private List<QueryStep> subSteps = new LinkedList<QueryStep>();
    private boolean silent = false;
    @Nullable
    private Boolean includeInferred;
    @Nullable
    private Boolean expandSameAs;
    private SparqlResponse previousExecution;
    private AtomicInteger limit;

    public QueryStep(String id, QueryStep parentStep, Function<RdfTree, String> queryBuilder, Supplier<Map<String, List<String>>> bindingsProvider) {
        this.id = id;
        this.parentStep = parentStep;
        this.queryBuilder = queryBuilder;
        this.bindingsProvider = bindingsProvider;
        if (parentStep != null) {
            parentStep.subSteps.add(this);
        }
    }

    public static List<QueryStep> from(List<SparqlExecutionStep> executionSteps) {
        List steps = executionSteps.stream().filter(executionStep -> !executionStep.isUpdate()).collect(Collectors.toList());
        Map stepMapping = executionSteps.stream().collect(Collectors.toMap(SparqlExecutionStep::getId, Function.identity()));
        LinkedHashMap queryStepMap = new LinkedHashMap();
        return steps.stream().map(step -> QueryStep.createQueryStep(step, stepMapping, queryStepMap)).collect(Collectors.toList());
    }

    private static QueryStep createQueryStep(SparqlExecutionStep step, Map<String, SparqlExecutionStep> stepMapping, Map<String, QueryStep> queryStepMap) {
        if (step == null) {
            return null;
        }
        if (queryStepMap.containsKey(step.getId())) {
            return queryStepMap.get(step.getId());
        }
        QueryStep parentStep = QueryStep.createQueryStep(step.getDependsOn().map(stepMapping::get).orElse(null), stepMapping, queryStepMap);
        QueryStep queryStep = new QueryStep(step.getId(), parentStep, rdfData -> step.getQuery(new PreviousExecution(rdfData)), () -> ((SparqlExecutionStep)step).getBindings());
        queryStepMap.put(step.getId(), queryStep);
        return queryStep;
    }

    public static QueryStep fromQuery(String query) {
        return new QueryStep(UUID.randomUUID().toString(), null, rdfData -> query, Collections::emptyMap);
    }

    public QueryStep getDependsOn() {
        return this.parentStep;
    }

    public String getQuery(SparqlResponse previousExecution) {
        RdfTree rdfData = null;
        if (previousExecution != null) {
            rdfData = previousExecution.getData();
        }
        return this.queryBuilder.apply(rdfData);
    }

    public Map<String, List<String>> getBindings() {
        return this.bindingsProvider.get();
    }

    public String getId() {
        return this.id;
    }

    public List<QueryStep> getSubSteps() {
        return this.subSteps;
    }

    public boolean isRootNode() {
        return this.getDependsOn() == null;
    }

    public Collection<QueryStep> getNodes() {
        return this.getSubSteps();
    }

    public SparqlResponse getPreviousExecution() {
        return this.previousExecution;
    }

    public void prepareForRequestBuilding(SparqlResponse previousExecution, AtomicInteger limit) {
        this.previousExecution = previousExecution;
        this.limit = limit;
    }

    public AtomicInteger getLimit() {
        if (this.limit == null) {
            return new AtomicInteger(Integer.MAX_VALUE);
        }
        return this.limit;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public SparqlRequest<String> toSparqlRequest(SomlSchema schema) {
        QueryRequest request = new QueryRequest(this.getId(), this.getQuery(this.getPreviousExecution()), this.getBindings(), schema, this.getLimit());
        if (this.isSilent()) {
            request.disableRequestLogging();
        }
        request.setIncludeInferred(this.getIncludeInferred());
        request.setExpandOverSameAs(this.getExpandSameAs());
        return request;
    }

    @Nullable
    public Boolean getIncludeInferred() {
        return this.includeInferred;
    }

    public QueryStep setIncludeInferred(@Nullable Boolean includeInferred) {
        this.includeInferred = includeInferred;
        return this;
    }

    @Nullable
    public Boolean getExpandSameAs() {
        return this.expandSameAs;
    }

    public QueryStep setExpandSameAs(@Nullable Boolean expandSameAs) {
        this.expandSameAs = expandSameAs;
        return this;
    }
}

