/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.PostQueryProcessor;
import com.ontotext.graphql.responder.QueryStep;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.sparql.ConnectionReusePolicies;
import com.ontotext.sparql.ConnectionReusePolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class QueryExecution
implements EndpointExecution {
    private final List<QueryStep> querySteps;
    private final Query graphQuery;
    private final Endpoint endpoint;
    private ConnectionReusePolicy connectionReusePolicy = ConnectionReusePolicies.noConnectionReuse();
    private final String requestId;
    private List<PostQueryProcessor> postProcessors = new ArrayList<PostQueryProcessor>();
    private boolean silent = false;
    private int index;
    private String txId;

    QueryExecution(String requestId, Query query, List<QueryStep> querySteps, Endpoint endpoint) {
        this.requestId = requestId;
        this.querySteps = Collections.unmodifiableList(new ArrayList<QueryStep>(querySteps));
        this.graphQuery = query;
        this.endpoint = endpoint;
        Arguments arguments = this.graphQuery.getArguments();
        if (arguments != null) {
            arguments.getExpandOverOwlSameAs().ifPresent(expandOwlSameAs -> querySteps.forEach(queryStep -> queryStep.setExpandSameAs((Boolean)expandOwlSameAs)));
            arguments.getIncludeInferred().ifPresent(includeInferred -> querySteps.forEach(queryStep -> queryStep.setIncludeInferred((Boolean)includeInferred)));
        }
    }

    public List<QueryStep> getQuerySteps() {
        return this.querySteps;
    }

    public Query getGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public SomlSchema getSchema() {
        return this.graphQuery.getSchema();
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    public void setTxId(String txId) {
        this.txId = Objects.requireNonNull(txId, "Transaction id is required");
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setConnectionReusePolicy(ConnectionReusePolicy connectionReusePolicy) {
        this.connectionReusePolicy = connectionReusePolicy;
    }

    @Override
    public ConnectionReusePolicy getConnectionReusePolicy() {
        return this.connectionReusePolicy;
    }

    public List<PostQueryProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void addPostProcessor(PostQueryProcessor postQueryProcessor) {
        this.postProcessors.add(postQueryProcessor);
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public void setSilent(boolean silent) {
        this.silent = true;
        this.querySteps.forEach(queryStep -> queryStep.setSilent(silent));
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }
}

