/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.EndpointInvokerStore;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequestProcessor;
import com.ontotext.graphql.responder.MutationSparqlEndpointInvoker;
import com.ontotext.graphql.responder.QuerySparqlEndpointInvoker;
import com.ontotext.graphql.responder.RequestPreProcessor;
import com.ontotext.graphql.responder.Responder;
import com.ontotext.rdf.transformer.RdfTransformerFactory;
import com.ontotext.rdf.transformer.RdfTransformers;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.sparql.ExecutionError;
import com.ontotext.soaas.plugin.PluginsManager;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;

public class GraphQlResponder
implements Responder,
Closeable {
    private final RdfTransformers rdfTransformers;
    private final EndpointInvokerResolver invokerStore;
    private List<ExecutionRequestProcessor> requestProcessors;
    private List<RequestPreProcessor> requestPreProcessors = new ArrayList<RequestPreProcessor>();

    private GraphQlResponder(EndpointInvokerResolver invokerResolver, RdfTransformers rdfTransformers) {
        this.invokerStore = invokerResolver;
        this.rdfTransformers = rdfTransformers;
        this.loadPreProcessors();
    }

    @Override
    public boolean isSupported(String format) {
        return this.rdfTransformers.isSupported(format);
    }

    @Override
    public <E extends EndpointExecution> List<TransformContext> processRequest(ExecutionRequest<E> executionContext) {
        ExecutionRequestProcessor requestProcessor = this.getRequestProcessors().stream().filter(executionRequestProcessor -> executionRequestProcessor.accept(executionContext)).findFirst().orElseThrow(this.unsupportedRequestFormat(executionContext));
        try {
            this.callPreProcessors(executionContext);
        }
        catch (RuntimeException re) {
            executionContext.addError((Serializable)new ExecutionError(re.getMessage(), (Throwable)re));
            executionContext.getExecutions().forEach(exec -> exec.getGraphQuery().invalidate());
        }
        return requestProcessor.processRequest(executionContext, this.invokerStore);
    }

    private <E extends EndpointExecution> void callPreProcessors(ExecutionRequest<E> execContext) {
        for (RequestPreProcessor requestPreProcessor : this.requestPreProcessors) {
            requestPreProcessor.processRequest(execContext, this.invokerStore);
        }
    }

    private void loadPreProcessors() {
        this.requestPreProcessors.addAll(PluginsManager.loadPlugins(RequestPreProcessor.class));
    }

    @Override
    public <E extends EndpointExecution> Object transform(List<TransformContext> transformContexts, ExecutionRequest<E> executionContext, String format) {
        return this.rdfTransformers.transform(format, executionContext.getSomlSchema(), transformContexts);
    }

    private <E extends EndpointExecution> Supplier<IllegalArgumentException> unsupportedRequestFormat(ExecutionRequest<E> executionContext) {
        return () -> new IllegalArgumentException("Unsupported request former: " + executionContext.getClass().getName());
    }

    private List<ExecutionRequestProcessor> getRequestProcessors() {
        if (this.requestProcessors == null) {
            this.requestProcessors = PluginsManager.loadPlugins(ExecutionRequestProcessor.class);
        }
        return this.requestProcessors;
    }

    public static GraphQlResponder createDefault() {
        return new Builder().registerInvoker(new QuerySparqlEndpointInvoker()).registerInvoker(new MutationSparqlEndpointInvoker()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void close() {
        this.invokerStore.close();
        if (this.requestProcessors != null) {
            for (ExecutionRequestProcessor processor : this.requestProcessors) {
                if (!(processor instanceof Closeable)) continue;
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)processor)), null);
            }
        }
    }

    public static class Builder {
        private Set<EndpointInvoker> endpointInvokers = new LinkedHashSet<EndpointInvoker>();
        private RdfTransformers rdfTransformers = new RdfTransformers();

        public Builder registerInvoker(EndpointInvoker invoker) {
            this.endpointInvokers.add(invoker);
            return this;
        }

        public Builder registerRdfTransformerFactory(RdfTransformerFactory transformerFactory) {
            this.rdfTransformers.registerRdfTransformerFactory(transformerFactory);
            return this;
        }

        public Builder setOutputValidation(boolean withValidation) {
            if (withValidation) {
                this.rdfTransformers.enableValidations();
            } else {
                this.rdfTransformers.disableValidations();
            }
            return this;
        }

        public Builder setTransformOptions(Map<String, Object> options) {
            this.rdfTransformers.setOptions(options);
            return this;
        }

        public GraphQlResponder build() {
            return new GraphQlResponder(new EndpointInvokerStore(this.endpointInvokers), this.rdfTransformers);
        }
    }
}

