/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecution;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public abstract class BaseExecutionRequest<E extends EndpointExecution>
implements ExecutionRequest<E> {
    private final SomlSchema somlSchema;
    private ShaclSchema shaclSchema;
    private boolean silent = false;
    private String txId = UUID.randomUUID().toString();
    private List<Serializable> errors = new LinkedList<Serializable>();
    private List<Serializable> warnings = new LinkedList<Serializable>();

    protected BaseExecutionRequest(SomlSchema somlSchema, ShaclSchema shaclSchema) {
        this.somlSchema = somlSchema;
        this.shaclSchema = shaclSchema;
    }

    @Override
    public void addError(Serializable error) {
        this.errors.add(error);
    }

    @Override
    public void addErrors(List<Serializable> errors) {
        this.errors.addAll(errors);
    }

    @Override
    public List<Serializable> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public void addWarning(Serializable warning) {
        this.warnings.add(warning);
    }

    @Override
    public void addWarnings(List<Serializable> warnings) {
        this.warnings.addAll(warnings);
    }

    @Override
    public List<Serializable> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    @Override
    public SomlSchema getSomlSchema() {
        return this.somlSchema;
    }

    @Override
    public ShaclSchema getShaclSchema() {
        return this.shaclSchema;
    }

    public void setShaclSchema(ShaclSchema shaclSchema) {
        this.shaclSchema = shaclSchema;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public String getTxId() {
        return this.txId;
    }

    public void setTxId(String txId) {
        this.txId = txId;
    }
}

