/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

@InternalUseOnly
public final class InternedIRI
implements IRI {
    private static final long serialVersionUID = 169243429049169159L;
    private final String namespace;
    private final String localName;
    private final String stringValue;
    private final int hashCode;

    public InternedIRI(String namespace, String localName) {
        this.namespace = namespace;
        this.localName = localName;
        this.stringValue = namespace.concat(localName).intern();
        this.hashCode = this.stringValue.hashCode();
    }

    @Override
    public String stringValue() {
        return this.stringValue;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public String toString() {
        return this.stringValue;
    }

    @Override
    public boolean equals(Object o) {
        Value value;
        if (this == o) {
            return true;
        }
        if (o instanceof InternedIRI) {
            return this.stringValue == ((InternedIRI)o).stringValue;
        }
        if (o instanceof Value && (value = (Value)o).isIRI()) {
            return this.stringValue.equals(value.stringValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.hashCode);
        out.writeUTF(this.namespace);
        out.writeUTF(this.localName);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        int hashCode = in.readInt();
        String namespace = in.readUTF();
        String localName = in.readUTF();
        this.writeToPrivateFinalField(namespace, "namespace");
        this.writeToPrivateFinalField(localName, "localName");
        this.writeToPrivateFinalField(hashCode, "hashCode");
        String stringValue = (namespace + localName).intern();
        this.writeToPrivateFinalField(stringValue, "stringValue");
        assert (stringValue.hashCode() == hashCode);
    }

    private void writeToPrivateFinalField(String value, String fieldName) {
        try {
            Field field = InternedIRI.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeToPrivateFinalField(int value, String fieldName) {
        try {
            Field field = InternedIRI.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

