/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.Util;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.console.setting.ConsoleSetting;
import org.eclipse.rdf4j.console.setting.WorkDir;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;

public class Convert
extends ConsoleCommand {
    @Override
    public String getName() {
        return "convert";
    }

    @Override
    public String getHelpShort() {
        return "Converts a file from one RDF format to another";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nconvert <fileFrom> <fileTo>   Converts a file from one RDF format to another\n";
    }

    @Override
    public String[] usesSettings() {
        return new String[]{"workdir"};
    }

    public Convert(ConsoleIO consoleIO, ConsoleState state, Map<String, ConsoleSetting> settings) {
        super(consoleIO, state, settings);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length < 3) {
            this.writeln(this.getHelpLong());
            return;
        }
        this.convert(tokens[1], tokens[2]);
    }

    private Path getWorkDir() {
        return (Path)((WorkDir)this.settings.get("workdir")).get();
    }

    private void convert(String fileFrom, String fileTo) {
        boolean overwrite;
        Path pathFrom = Util.getNormalizedPath(this.getWorkDir(), fileFrom);
        if (pathFrom == null) {
            this.writeError("Invalid file name (from) " + fileFrom);
            return;
        }
        if (Files.notExists(pathFrom, new LinkOption[0])) {
            this.writeError("File not found (from) " + fileFrom);
            return;
        }
        Optional fmtFrom = Rio.getParserFormatForFileName((String)fileFrom);
        if (fmtFrom.isEmpty()) {
            this.writeError("No RDF parser for " + fileFrom);
            return;
        }
        Path pathTo = Util.getNormalizedPath(this.getWorkDir(), fileTo);
        if (pathTo == null) {
            this.writeError("Invalid file name (to) " + String.valueOf(pathTo));
            return;
        }
        Optional fmtTo = Rio.getWriterFormatForFileName((String)fileTo);
        if (fmtTo.isEmpty()) {
            this.writeError("No RDF writer for " + fileTo);
            return;
        }
        if (Files.exists(pathTo, new LinkOption[0]) && !(overwrite = this.askProceed("File exists, continue ?", false))) {
            this.writeln("Conversion aborted");
            return;
        }
        RDFParser parser = Rio.createParser((RDFFormat)((RDFFormat)fmtFrom.get()));
        String baseURI = pathFrom.toUri().toString();
        try (BufferedInputStream r = new BufferedInputStream(Files.newInputStream(pathFrom, new OpenOption[0]));
             BufferedWriter w = Files.newBufferedWriter(pathTo, new OpenOption[0]);){
            RDFWriter writer = Rio.createWriter((RDFFormat)((RDFFormat)fmtTo.get()), (Writer)w);
            parser.setRDFHandler((RDFHandler)writer);
            long startTime = System.nanoTime();
            this.writeln("Converting file ...");
            parser.parse((InputStream)r, baseURI);
            long diff = (System.nanoTime() - startTime) / 1000000L;
            this.writeln("Data has been written to file (" + diff + " ms)");
        }
        catch (IOException | RDFHandlerException | RDFParseException e) {
            this.writeError("Failed to convert data", (Exception)e);
        }
    }
}

