/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import it.unibz.inf.ontop.exception.InvalidOntopConfigurationException;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopMappingSettings;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopStandaloneSQLSettings;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyBuilders;
import it.unibz.inf.ontop.injection.impl.OntopMappingOntologyConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopStandaloneSQLConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopStandaloneSQLSettingsImpl;
import it.unibz.inf.ontop.spec.OBDASpecification;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class OntopSQLOWLAPIConfigurationImpl
extends OntopStandaloneSQLConfigurationImpl
implements OntopSQLOWLAPIConfiguration {
    private final OntopMappingOntologyConfigurationImpl mappingOWLConfiguration;

    OntopSQLOWLAPIConfigurationImpl(OntopStandaloneSQLSettings settings, OntopSQLOWLAPIOptions options) {
        super(settings, options.sqlOptions);
        this.mappingOWLConfiguration = new OntopMappingOntologyConfigurationImpl((OntopMappingSettings)settings, options.ontologyOptions, () -> ((OntopSQLOWLAPIConfigurationImpl)this).getInjector());
    }

    OntopSQLOWLAPIConfigurationImpl(OntopStandaloneSQLSettings settings, OntopSQLOWLAPIOptions options, Supplier<Injector> injectorSupplier) {
        super(settings, options.sqlOptions, injectorSupplier);
        this.mappingOWLConfiguration = new OntopMappingOntologyConfigurationImpl((OntopMappingSettings)settings, options.ontologyOptions, injectorSupplier);
    }

    public OBDASpecification loadOBDASpecification() throws OBDASpecificationException {
        return this.loadSpecification(() -> ((OntopMappingOntologyConfigurationImpl)this.mappingOWLConfiguration).loadOntology(), () -> ((OntopMappingOntologyConfigurationImpl)this.mappingOWLConfiguration).loadInputFacts());
    }

    public Optional<OWLOntology> loadInputOntology() throws OWLOntologyCreationException {
        return this.mappingOWLConfiguration.loadInputOntology();
    }

    public Optional<ImmutableSet<RDFFact>> loadInputFacts() throws OBDASpecificationException {
        return this.mappingOWLConfiguration.loadInputFacts();
    }

    public static class BuilderImpl
    extends OntopSQLOWLAPIBuilderMixin<BuilderImpl> {
        @Override
        public OntopSQLOWLAPIConfiguration build() {
            OntopStandaloneSQLSettingsImpl settings = new OntopStandaloneSQLSettingsImpl(this.generateProperties(), this.isR2rml());
            OntopSQLOWLAPIOptions options = this.generateSQLOWLAPIOptions();
            return new OntopSQLOWLAPIConfigurationImpl((OntopStandaloneSQLSettings)settings, options);
        }

        protected BuilderImpl self() {
            return this;
        }
    }

    protected static abstract class OntopSQLOWLAPIBuilderMixin<B extends OntopSQLOWLAPIConfiguration.Builder<B>>
    extends OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLBuilderMixin<B>
    implements OntopSQLOWLAPIConfiguration.Builder<B> {
        private final OntopMappingOntologyBuilders.StandardMappingOntologyBuilderFragment<B> ontologyBuilderFragment = new OntopMappingOntologyBuilders.StandardMappingOntologyBuilderFragment<B>(){

            protected B self() {
                return (OntopSQLOWLAPIConfiguration.Builder)this.self();
            }

            protected void declareOntologyDefined() {
                this.declareOntologyDefined();
            }
        };
        private boolean isOntologyDefined = false;

        protected OntopSQLOWLAPIBuilderMixin() {
        }

        public B ontologyFile(@Nonnull String urlOrPath) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(urlOrPath));
        }

        public B xmlCatalogFile(@Nonnull String xmlCatalogFile) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.xmlCatalogFile(xmlCatalogFile));
        }

        public B ontologyFile(@Nonnull URL url) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(url));
        }

        public B ontologyFile(@Nonnull File owlFile) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyFile(owlFile));
        }

        public B ontologyReader(@Nonnull Reader reader) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.ontologyReader(reader));
        }

        public B factsFile(@Nonnull String urlOrPath) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsFile(urlOrPath));
        }

        public B factFormat(@Nonnull String factFormat) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factFormat(factFormat));
        }

        public B factsBaseIRI(@Nonnull String factsBaseIRI) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsBaseIRI(factsBaseIRI));
        }

        public B factsFile(@Nonnull URL url) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsFile(url));
        }

        public B factsFile(@Nonnull File owlFile) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsFile(owlFile));
        }

        public B factsReader(@Nonnull Reader reader) {
            return (B)((OntopSQLOWLAPIConfiguration.Builder)this.ontologyBuilderFragment.factsReader(reader));
        }

        protected final void declareOntologyDefined() {
            if (this.isOntologyDefined) {
                throw new InvalidOntopConfigurationException("Ontology already defined!");
            }
            this.isOntologyDefined = true;
        }

        protected final OntopSQLOWLAPIOptions generateSQLOWLAPIOptions() {
            OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLOptions standaloneSQLOptions = this.generateStandaloneSQLOptions();
            OntopMappingOntologyBuilders.OntopMappingOntologyOptions mappingOntologyOptions = this.ontologyBuilderFragment.generateMappingOntologyOptions(standaloneSQLOptions.mappingOptions.mappingSQLOptions.mappingOptions);
            return new OntopSQLOWLAPIOptions(standaloneSQLOptions, mappingOntologyOptions);
        }
    }

    static class OntopSQLOWLAPIOptions {
        final OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLOptions sqlOptions;
        final OntopMappingOntologyBuilders.OntopMappingOntologyOptions ontologyOptions;

        OntopSQLOWLAPIOptions(OntopStandaloneSQLConfigurationImpl.OntopStandaloneSQLOptions sqlOptions, OntopMappingOntologyBuilders.OntopMappingOntologyOptions ontologyOptions) {
            this.sqlOptions = sqlOptions;
            this.ontologyOptions = ontologyOptions;
        }
    }
}

