/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.graphql.parser.OperationPostProcessor;
import com.ontotext.models.Constraint;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Severity;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.security.RbacRestrictions;
import com.ontotext.models.security.RbacResult;
import com.ontotext.models.security.Role;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.util.RbacUtils;
import com.ontotext.rbac.validator.RbacConstraintsValidationContext;
import com.ontotext.rbac.validator.RbacConstraintsValidator;
import com.ontotext.soaas.plugin.Order;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Order(value=2000)
public class RbacMutationConstraintsValidator
extends RbacConstraintsValidator
implements OperationValidator,
OperationPostProcessor {
    private static final String CREATE_FILTERED = "security.rbac.create.filter.applied";
    private static final String UPDATE_FILTERED = "security.rbac.mutation.filter.applied";
    private static final String DELETE_FILTERED = "security.rbac.delete.restricted";

    @Override
    public boolean isEnabled(ValidatorOptions options) {
        if (!super.isEnabled(options)) {
            return false;
        }
        return options.isEnabled(this.getClass());
    }

    public void postProcess(Operation operation, SecurityContext securityContext) {
        if (this.isSecurityNotEnabled() || !this.isMutation(operation)) {
            return;
        }
        RbacConstraintsValidationContext context = this.buildPostProcessingContext(operation, securityContext);
        Shape responseType = ((Mutation)operation).getResponseTypeInstance();
        this.doValidateMutation(operation, context, responseType);
    }

    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        if (!operation.getOperationType().isMutation()) {
            return OperationResponse.EMPTY;
        }
        ValidatorOptions options = validationContext.getValidatorOptions();
        if (!this.isEnabled(options)) {
            return OperationResponse.EMPTY;
        }
        RbacConstraintsValidationContext context = this.buildValidationContext(operation, validationContext);
        Shape responseType = ((Mutation)operation).getResponseTypeInstance();
        return this.doValidateMutation(operation, context, responseType);
    }

    private OperationResponse doValidateMutation(Operation operation, RbacConstraintsValidationContext context, Shape responseType) {
        if (!this.isReturnTypeAccessible(context, responseType, Collections.singleton(operation.getLocation()))) {
            return context.getResponse();
        }
        if (!this.validateMutation(context, responseType)) {
            return context.getResponse();
        }
        this.addConstraintsOrWarningsToQuerySelections(context, operation.getSelections());
        return context.getResponse();
    }

    private boolean validateMutation(RbacConstraintsValidationContext context, Shape shape) {
        if (OperationType.DELETE.equals((Object)context.getOperationType())) {
            return this.validateDeleteMutation(context, shape);
        }
        List<Change> changes = context.getOperation().getArguments().getChanges().orElse(Collections.emptyList());
        this.replaceContextVariablesInChange(context, changes);
        return changes.stream().map(change -> this.validateMutationChanges(context, (Change)change)).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }

    private boolean validateDeleteMutation(RbacConstraintsValidationContext context, Shape shape) {
        if (!this.canDeleteShapeFields(context, shape)) {
            context.addMessage(Severity.ERROR, DELETE_FILTERED, Collections.singleton(context.getOperation().getLocation()), this.getGraphqlName(shape), context.getAuthorizationsAsString());
            return false;
        }
        return true;
    }

    private boolean canDeleteShapeFields(RbacConstraintsValidationContext context, Shape shape) {
        RbacRestrictions restrictions = context.getRestrictions();
        Set<Role> roles = context.getRoles();
        return shape.getAllProperties().values().stream().allMatch(property -> restrictions.canDelete(shape, property.getName(), roles).isAllowed());
    }

    private void replaceContextVariablesInChange(RbacConstraintsValidationContext context, List<Change> changes) {
        changes.stream().filter(change -> change.getConstraints() != null).filter(change -> !change.getConstraints().isEmpty()).forEach(change -> change.setConstraints(RbacUtils.replaceContextVariables(change.getConstraints(), context)));
    }

    private boolean validateMutationChanges(RbacConstraintsValidationContext context, Change change) {
        OperationType operationType = change.getType();
        Shape shape = change.getShape();
        boolean isValidMutation = true;
        Set<Constraint> constraints = new HashSet<Constraint>();
        if (OperationType.CREATE.equals((Object)operationType) && !this.canWriteIdentifier(context, change, constraints)) {
            isValidMutation = false;
            this.reportCannotCreateError(context, shape, "id", Collections.singleton(change.getSourceLocation()));
        }
        for (PropertyChange propertyChange : change.getChanges()) {
            PropertyShape property = RbacMutationConstraintsValidator.resolveProperty(shape, propertyChange.getName(), context.getSchema());
            Object rawValue = propertyChange.getRawValue();
            if (rawValue instanceof Collection) {
                isValidMutation &= this.areValidPropertyModifications(context, operationType, shape, propertyChange, property, constraints).booleanValue();
                continue;
            }
            isValidMutation &= this.isValidPropertyModification(context, operationType, shape, property, rawValue, propertyChange.getSourceLocations(), constraints);
        }
        if (change.hasPreconditions() && change.getPreconditions().getParentChange() != null) {
            Change parentChange = change.getPreconditions().getParentChange();
            PropertyShape property = change.getPreconditions().getIncomingRelation();
            isValidMutation &= this.isValidPropertyModification(context, operationType, parentChange.getShape(), property, new Object(), Collections.singleton(change.getSourceLocation()), new HashSet<Constraint>());
        }
        if (!constraints.isEmpty()) {
            constraints = RbacUtils.replaceContextVariables(constraints, context);
            if (OperationType.CREATE.equals((Object)operationType)) {
                this.addConstraintsToChangeMutation(context, change, constraints);
            } else if (OperationType.UPDATE.equals((Object)operationType) && !change.hasConstraints()) {
                change.setConstraints(constraints);
            }
        }
        return isValidMutation;
    }

    private void addConstraintsToChangeMutation(RbacConstraintsValidationContext context, Change change, Set<Constraint> constraints) {
        change.setConstraints(constraints);
        this.raiseWarningForFilterConstrainedResult(context, Collections.singletonList(change.getSourceLocation()), RbacUtils.replaceContextVariables(constraints, context), change.getShape(), null, CREATE_FILTERED);
    }

    private boolean canWriteIdentifier(RbacConstraintsValidationContext context, Change change, Set<Constraint> constraints) {
        RbacResult result = context.getRestrictions().canWrite(change.getShape(), "id", context.getRoles());
        if (result.isConstrained()) {
            constraints.addAll(result.getConstraints());
        }
        return result.isAllowed();
    }

    private Boolean areValidPropertyModifications(RbacConstraintsValidationContext context, OperationType changeType, Shape shape, PropertyChange propertyChange, PropertyShape property, Set<Constraint> constraints) {
        Collection values = propertyChange.getRawValueAsCollection();
        List locations = propertyChange.getSourceLocations();
        if (values.isEmpty()) {
            return this.isValidPropertyModification(context, changeType, shape, property, values, locations, constraints);
        }
        return values.stream().map(val -> this.isValidPropertyModification(context, changeType, shape, property, val, locations, constraints)).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }

    private boolean isValidPropertyModification(RbacConstraintsValidationContext context, OperationType operationType, Shape shape, PropertyShape property, Object value, Collection<SourceLocation> locations, Set<Constraint> constraints) {
        Set<Role> roles = context.getRoles();
        if (OperationType.CREATE.equals((Object)operationType)) {
            return this.checkCreate(context, shape, property, value, roles, locations, constraints);
        }
        if (OperationType.UPDATE.equals((Object)operationType)) {
            return this.checkUpdate(context, shape, property, value, roles, locations, constraints);
        }
        return true;
    }

    private boolean checkCreate(RbacConstraintsValidationContext context, Shape shape, PropertyShape property, Object value, Set<Role> roles, Collection<SourceLocation> locations, Set<Constraint> constraints) {
        String propertyName = property.getName();
        RbacResult rbacResult = context.getRestrictions().canWrite(shape, propertyName, roles);
        if (!rbacResult.isAllowed()) {
            this.reportCannotCreateError(context, shape, propertyName, locations);
            return false;
        }
        if (rbacResult.isConstrained() && constraints != null) {
            constraints.addAll(rbacResult.getConstraints());
        }
        return this.isAllowedAccessOfTheOtherObjectId(context, property, value, locations);
    }

    private boolean checkUpdate(RbacConstraintsValidationContext context, Shape shape, PropertyShape property, Object value, Set<Role> roles, Collection<SourceLocation> locations, Set<Constraint> constraints) {
        String propertyName = property.getName();
        RbacResult canWrite = context.getRestrictions().canWrite(shape, propertyName, roles);
        if (!canWrite.isAllowed()) {
            this.reportCannotUpdateError(context, shape, propertyName, locations);
            return false;
        }
        if (canWrite.isConstrained()) {
            constraints.addAll(canWrite.getConstraints());
            this.raiseWarningForFilterConstrainedResult(context, locations, RbacUtils.replaceContextVariables(canWrite.getConstraints(), context), shape, propertyName, UPDATE_FILTERED);
        }
        if (!this.canClearPropertyValue(context, shape, propertyName, value)) {
            this.reportCannotDeleteError(context, shape, propertyName, locations);
            return false;
        }
        return this.isAllowedAccessOfTheOtherObjectId(context, property, value, locations);
    }

    private boolean isAllowedAccessOfTheOtherObjectId(RbacConstraintsValidationContext context, PropertyShape property, Object value, Collection<SourceLocation> locations) {
        String range = property.getRange();
        if (property.isScalarType() && !"iri".equals(range)) {
            return true;
        }
        Shape type = (Shape)context.getSchema().getObjects().get((Object)range);
        if (type == null) {
            type = property.getContainedIn().getContainedIn();
        }
        if (value != null && !this.hasWriteIdPermissions(context, type)) {
            this.reportError("security.rbac.field.access.restricted", context, type, "id", locations);
            return false;
        }
        return true;
    }

    private boolean hasWriteIdPermissions(RbacConstraintsValidationContext context, Shape type) {
        RbacRestrictions restrictions = context.getRestrictions();
        Set<Role> roles = context.getRoles();
        return restrictions.canWrite(type, "id", roles).isAllowed();
    }

    private boolean canClearPropertyValue(RbacConstraintsValidationContext context, Shape shape, String propertyName, Object value) {
        if (context.getRestrictions().canDelete(shape, propertyName, context.getRoles()).isAllowed()) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        return true;
    }

    private void reportCannotCreateError(RbacConstraintsValidationContext context, Shape shape, String property, Collection<SourceLocation> locations) {
        this.reportError("security.rbac.field.create.restricted", context, shape, property, locations);
    }

    private void reportCannotUpdateError(RbacConstraintsValidationContext context, Shape shape, String property, Collection<SourceLocation> locations) {
        this.reportError("security.rbac.field.update.restricted", context, shape, property, locations);
    }

    private void reportCannotDeleteError(RbacConstraintsValidationContext context, Shape shape, String property, Collection<SourceLocation> locations) {
        this.reportError("security.rbac.field.update.empty", context, shape, property, locations);
    }

    private void reportError(String messageId, RbacConstraintsValidationContext context, Shape shape, String property, Collection<SourceLocation> locations) {
        String roles = context.getAuthorizationsAsString();
        String shapeName = this.getGraphqlName(shape);
        context.addMessage(Severity.ERROR, messageId, locations, property, shapeName, roles);
    }
}

