/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.validator;

import com.ontotext.models.Constraint;
import com.ontotext.models.OperationType;
import com.ontotext.models.Selection;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.ChangePreconditions;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.ReferenceId;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.mutation.data.generation.DataGenerationContext;
import com.ontotext.models.mutation.data.generation.DataGenerator;
import com.ontotext.models.query.Query;
import com.ontotext.models.security.RbacRestrictions;
import com.ontotext.models.security.RbacResult;
import com.ontotext.models.security.Role;
import com.ontotext.models.subscriptions.Subscription;
import com.ontotext.rbac.validator.RbacConstraintsValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RbacMutationChangeSplitter
implements DataGenerator {
    public OperationResponse visit(Query query, DataGenerationContext context) {
        return OperationResponse.EMPTY;
    }

    public OperationResponse visit(Selection selection, DataGenerationContext context) {
        return OperationResponse.EMPTY;
    }

    public OperationResponse visit(CreateMutation mutation, DataGenerationContext context) {
        return OperationResponse.EMPTY;
    }

    public OperationResponse visit(UpdateMutation mutation, DataGenerationContext context) {
        return this.visitMutation((Mutation)mutation, context);
    }

    public OperationResponse visit(DeleteMutation deleteMutation, DataGenerationContext context) {
        return OperationResponse.EMPTY;
    }

    public OperationResponse visit(Subscription subscription, DataGenerationContext context) {
        return OperationResponse.EMPTY;
    }

    private OperationResponse visitMutation(Mutation mutation, DataGenerationContext context) {
        if (!context.getOptions().isEnabled(RbacConstraintsValidator.class)) {
            return OperationResponse.EMPTY;
        }
        if (!context.getOptions().isEnabled(RbacMutationChangeSplitter.class)) {
            return OperationResponse.EMPTY;
        }
        if (context.getData() == null || context.getData().get("roles") == null) {
            return OperationResponse.EMPTY;
        }
        RbacRestrictions restrictions = context.getSomlSchema().getRbac().getRestrictions();
        Set roles = (Set)context.getData().get("roles");
        LinkedList<Change> newChanges = new LinkedList<Change>();
        HashSet<Change> toRemove = new HashSet<Change>();
        for (Change change : mutation.getChanges()) {
            Set<Constraint> commonConstraints;
            if (change.getType() != OperationType.UPDATE) continue;
            Map<Set<Constraint>, List<PropertyChange>> propChangeConstrMap = this.collectPropChangesPerConstraintSet(restrictions, roles, change);
            if (propChangeConstrMap.size() > 1) {
                Map<String, Change> nestedCreateIds = this.getNestedCreates(change);
                ArrayList<Change> newChangesForCurrentChange = new ArrayList<Change>(propChangeConstrMap.size());
                this.createNewChanges(change, propChangeConstrMap, nestedCreateIds, newChangesForCurrentChange);
                this.updateParentChange(change, newChangesForCurrentChange);
                toRemove.add(change);
                newChanges.addAll(newChangesForCurrentChange);
                continue;
            }
            if (propChangeConstrMap.size() != 1 || (commonConstraints = propChangeConstrMap.keySet().iterator().next()).isEmpty()) continue;
            change.setConstraints(commonConstraints);
        }
        if (!toRemove.isEmpty()) {
            mutation.getChanges().removeAll(toRemove);
            mutation.getChanges().addAll(newChanges);
        }
        return OperationResponse.EMPTY;
    }

    private void updateParentChange(Change change, List<Change> newChangesForCurrentChange) {
        Change parentChange;
        if (change.getPreconditions() != null && (parentChange = change.getPreconditions().getParentChange()) != null) {
            parentChange.getNestedChanges().remove(change);
            parentChange.getNestedChanges().addAll(newChangesForCurrentChange);
        }
    }

    private void createNewChanges(Change change, Map<Set<Constraint>, List<PropertyChange>> propChangeConstrMap, Map<String, Change> nestedCreateIds, List<Change> newChangesForCurrentChange) {
        for (Map.Entry<Set<Constraint>, List<PropertyChange>> setListEntry : propChangeConstrMap.entrySet()) {
            Change newChange = change.copyShallow();
            newChange.getNestedChanges().clear();
            List<PropertyChange> propChanges = setListEntry.getValue();
            this.addNestedCreatesAsNestedChanges(nestedCreateIds, newChange, propChanges);
            newChange.setId(ReferenceId.randomId());
            newChange.setCollectChangesIn(change.getTransactionId());
            newChange.getChanges().clear();
            newChange.getChanges().addAll(propChanges);
            newChange.setConstraints(setListEntry.getKey());
            newChangesForCurrentChange.add(newChange);
        }
    }

    private Map<Set<Constraint>, List<PropertyChange>> collectPropChangesPerConstraintSet(RbacRestrictions restrictions, Set<Role> roles, Change change) {
        HashMap<Set<Constraint>, List<PropertyChange>> propChangeConstrMap = new HashMap<Set<Constraint>, List<PropertyChange>>();
        for (PropertyChange propChange : change.getChanges()) {
            String propertyName = change.getSchema().getPrefixes().nameToShortIri(propChange.getName());
            RbacResult result = restrictions.canWrite(change.getShape(), propertyName, roles);
            if (!result.isAllowed()) continue;
            Set constraints = result.getConstraints();
            if (constraints == null) {
                constraints = Collections.emptySet();
            }
            propChangeConstrMap.computeIfAbsent(constraints, key -> new LinkedList()).add(propChange);
        }
        return propChangeConstrMap;
    }

    private void addNestedCreatesAsNestedChanges(Map<String, Change> nestedCreateIds, Change newChange, List<PropertyChange> propChanges) {
        for (Map.Entry<String, Change> entry : nestedCreateIds.entrySet()) {
            if (!this.propertiesContainUpdateForANestedCreate(propChanges, entry)) continue;
            Change nestedCreate = entry.getValue();
            ChangePreconditions existPc = nestedCreate.getPreconditions();
            ChangePreconditions newPc = new ChangePreconditions(newChange, existPc);
            nestedCreate.setPreconditions(newPc);
        }
    }

    private boolean propertiesContainUpdateForANestedCreate(List<PropertyChange> propChanges, Map.Entry<String, Change> entry) {
        return propChanges.stream().anyMatch(pc -> ((String)entry.getKey()).equals(pc.getRawValue()));
    }

    private Map<String, Change> getNestedCreates(Change change) {
        return change.getNestedChanges().stream().filter(nc -> nc.getType() == OperationType.CREATE).collect(Collectors.toMap(Change::getId, Function.identity()));
    }
}

