/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.models.Constraint;
import com.ontotext.models.Shape;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.ExpressionsFactory;
import com.ontotext.platform.GraphQlTypeUtil;
import com.ontotext.rbac.util.ContextValuesReplacer;
import com.ontotext.rbac.validator.RbacConstraintsValidationContext;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SinglePropertyResultHandler;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RbacUtils.class);
    private static final String WILDCARD = "*";
    private static final Pattern WHITESPACE = Pattern.compile("\\s");
    private static final Pattern WHERE = Pattern.compile("^\\(\\s*where\\s*:(.*)\\)$", 8);
    private static final Pattern KEY = Pattern.compile("([a-zA-Z1-9_.]+)");
    private static final Pattern LITERAL = Pattern.compile("(\".*?\"|'.*?'|\\$\\{.*?}|\\b[\\d.]+\\b)");
    private static final Pattern KEY_NOT_SEPARATED_WITH_COMMA = Pattern.compile("}(\"|\\s*\\{)");
    private static final ContextValuesReplacer CONTEXT_VALUES_REPLACER = new ContextValuesReplacer();
    private static final String TX_ROLLBACK_CHECK_QUERY = "select ?s where { \n\t?s <http://www.ontotext.com/owlim/system#listplugins> ?o .\n    FILTER (STR(?s) = \"tx-rollback\")\n    FILTER (?o = true)\n}";
    private static Boolean txPluginExists = null;

    private RbacUtils() {
    }

    public static Collection<Shape> resolveShapes(Map<String, Shape> shapes, String shapeFilter) {
        Shape shape2;
        Collection<Object> toReturn = WILDCARD.equals(shapeFilter) ? shapes.values() : (shapes.containsKey(shapeFilter) ? ((shape2 = shapes.get(shapeFilter)).isUnion() ? shape2.getConcreteSubTypes() : Collections.singleton(shape2)) : (Set<Shape>)((Object)shapes.values().stream().filter(shape -> shape.getId().matches(RbacUtils.toExpression(shapeFilter))).collect(Collectors.toList())));
        toReturn = new ArrayList<Shape>(toReturn);
        Collections.sort((List)toReturn, Comparator.comparing(Shape::getId));
        return toReturn;
    }

    public static Collection<Shape> resolveQueryableShapes(Map<String, Shape> shapes, String shapeFilter) {
        return RbacUtils.resolveShapes(shapes, shapeFilter).stream().filter(shape -> shape.isSynthetic() == false).filter(shape -> !GraphQlTypeUtil.getBaseTypes().contains(shape.getId())).collect(Collectors.toList());
    }

    public static String toExpression(String filter) {
        return "^" + filter.replace(WILDCARD, ".*") + "$";
    }

    public static Set<String> getFirstLevelSelection(String filter) throws JsonProcessingException {
        Map<String, Object> obj = RbacUtils.parseFilter(filter);
        return RbacUtils.getFirstSelection(obj);
    }

    public static Set<Constraint> replaceContextVariables(Set<Constraint> constraints, RbacConstraintsValidationContext context) {
        LinkedHashSet<Constraint> replaced = new LinkedHashSet<Constraint>(constraints.size());
        for (Constraint constraint : constraints) {
            if (constraint.getFilter() != null && constraint.getFilter().getFilter() != null) {
                replaced.add(new Constraint(constraint.getShapeId(), constraint.getFilter().acceptFilterVisitor((ExpressionVisitor)CONTEXT_VALUES_REPLACER, (ExpressionVisitorContext)new ContextValuesReplacer.ContextValuesReplacerContext(context))));
                continue;
            }
            replaced.add(constraint);
        }
        return replaced;
    }

    private static Set<String> getFirstSelection(Object obj) {
        LinkedHashSet<String> nodes = new LinkedHashSet<String>();
        if (obj instanceof Map) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                if (ExpressionsFactory.isNode((String)((String)entry.getKey()))) {
                    nodes.add((String)entry.getKey());
                    continue;
                }
                nodes.addAll(RbacUtils.getFirstSelection(entry.getValue()));
            }
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            collection.forEach(element -> nodes.addAll(RbacUtils.getFirstSelection(element)));
        }
        return nodes;
    }

    private static Map<String, Object> parseFilter(String filter) throws JsonProcessingException {
        WHITESPACE.matcher(filter).replaceAll("");
        Matcher matcher = WHERE.matcher(filter);
        if (!matcher.matches()) {
            return null;
        }
        filter = matcher.group(1);
        filter = LITERAL.matcher(filter).replaceAll("{}");
        Matcher keyMatcher = KEY.matcher(filter);
        filter = keyMatcher.replaceAll("\"$1\"");
        filter = KEY_NOT_SEPARATED_WITH_COMMA.matcher(filter).replaceAll("},$1");
        return (Map)new ObjectMapper().readValue(filter, HashMap.class);
    }

    public static boolean isLegacyValidation(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        return !RbacUtils.txRollbackPluginExists(request, context);
    }

    private static boolean txRollbackPluginExists(UpdateExecution request, MutationActiveValidator.ActiveValidationContext context) {
        HashMap<String, List<String>> bindings = new HashMap<String, List<String>>();
        bindings.put("s", Collections.singletonList("s"));
        if (txPluginExists != null) {
            return txPluginExists;
        }
        try {
            SinglePropertyResultHandler handler = new SinglePropertyResultHandler("s");
            ExecutionResponse resp = context.getSparqlInvoker().invoke((SparqlRequest)((QueryRequest)QueryRequest.newSimpleQuery((String)TX_ROLLBACK_CHECK_QUERY).disableRequestLogging()).setHandler((TupleQueryResultHandler)handler), (SparqlEndpoint)request.getEndpoint(), request.getConnectionReusePolicy());
            txPluginExists = resp.isSuccessful() && !handler.getResults().isEmpty();
            return txPluginExists;
        }
        catch (Exception ex) {
            LOGGER.error("Could not determine if the tx-rollback plugin exists", (Throwable)ex);
            return false;
        }
    }

    public static void reset() {
        txPluginExists = null;
    }
}

