/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.soml.access;

import com.ontotext.metamodel.SchemaUpdateConsumer;
import com.ontotext.metamodel.SomlSchemaManager;
import com.ontotext.metamodel.storage.SomlBindException;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.models.Rbac;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.SomlSchemaParser;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.rbac.SecurityContext;
import com.ontotext.rbac.exceptions.NoPermissionsException;
import com.ontotext.rbac.soml.access.SomlAccessCalculator;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.exceptions.PlatformConfigurationException;
import com.ontotext.soaas.common.exceptions.ShaclBindException;
import graphql.schema.GraphQLSchema;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class SecuredSomlSchemaManager
implements SomlSchemaManager {
    private SomlSchemaManager delegatee;
    private SomlSchemaManager rbacSchemaManager;
    private final SecurityContext securityContext;

    public SecuredSomlSchemaManager(SomlSchemaManager delegatee, SecurityContext securityContext) {
        this(delegatee, delegatee, securityContext);
    }

    public SecuredSomlSchemaManager(SomlSchemaManager delegatee, SomlSchemaManager rbacSchemaManager, SecurityContext securityContext) {
        this.delegatee = delegatee;
        this.rbacSchemaManager = rbacSchemaManager;
        this.securityContext = securityContext;
    }

    public SomlSchemaManager.SchemaInfo create(String schema) throws SomlStoreException {
        String id = SomlSchemaParser.getId((String)schema);
        this.verifyUserPermissions(id, RoleActionType.WRITE, this.securityContext);
        return this.delegatee.create(schema);
    }

    private void verifyUserPermissions(String id, RoleActionType operation, SecurityContext securityContext) {
        SomlAccessCalculator.verifyUserPermissions(id, operation, this.getRbac(), securityContext);
    }

    private void verifyShaclPermissions(RoleActionType action, SecurityContext securityContext) {
        try {
            this.verifyUserPermissions(this.delegatee.getSomlSchema().getId(), action, securityContext);
        }
        catch (SomlBindException sbe) {
            throw new ShaclBindException(sbe.getReason(), sbe.getErrorCode(), 404);
        }
    }

    private void verifyShaclPermissionsNoSchema(RoleActionType action, SecurityContext securityContext) {
        this.verifyUserPermissions("", action, securityContext);
    }

    public SomlSchemaManager.SchemaInfo update(String id, String schema) throws SomlStoreException {
        this.verifyUserPermissions(id, RoleActionType.WRITE, this.securityContext);
        return this.delegatee.update(id, schema);
    }

    public boolean bind(String id) throws SomlStoreException {
        this.verifyUserPermissions(id, RoleActionType.BIND, this.securityContext);
        return this.delegatee.bind(id);
    }

    public Collection<String> getAll() throws UnreachableStoreException {
        return this.getFilteredStream().collect(Collectors.toCollection(LinkedList::new));
    }

    public Collection<String> getAll(int skip, int limit) throws UnreachableStoreException {
        return this.getFilteredStream().skip(skip).limit(limit).collect(Collectors.toCollection(LinkedList::new));
    }

    private Stream<String> getFilteredStream() throws UnreachableStoreException {
        Rbac rbac = this.getRbac();
        return this.delegatee.getAll().stream().filter(schema -> {
            String id = SomlSchemaParser.getId((String)schema);
            return SomlAccessCalculator.hasPermissions(id, RoleActionType.READ, rbac, this.securityContext) && !"/soml/soml-rbac".equals(id);
        });
    }

    public Optional<String> get(String id) throws UnreachableStoreException {
        this.verifyUserPermissions(id, RoleActionType.READ, this.securityContext);
        return this.delegatee.get(id);
    }

    public boolean contains(String id) throws UnreachableStoreException {
        this.verifyUserPermissions(id, RoleActionType.READ, this.securityContext);
        return this.delegatee.contains(id);
    }

    public boolean remove(String id) throws UnreachableStoreException {
        this.verifyUserPermissions(id, RoleActionType.DELETE, this.securityContext);
        return this.delegatee.remove(id);
    }

    public void clearShaclSchema() {
        this.verifyShaclPermissions(RoleActionType.DELETE, this.securityContext);
        this.delegatee.clearShaclSchema();
    }

    public void setShaclTransactionMode(Boolean enable) {
        try {
            if (this.useUnrestricted().hasBoundSchema()) {
                this.verifyShaclPermissions(RoleActionType.WRITE, this.securityContext);
            } else {
                this.verifyShaclPermissionsNoSchema(RoleActionType.WRITE, this.securityContext);
            }
        }
        catch (UnreachableStoreException use) {
            throw new PlatformConfigurationException("Could not check for bound schema " + use.getMessage(), ErrorCode.SOML_STORE_UNREACHABLE);
        }
        this.delegatee.setShaclTransactionMode(enable);
    }

    public boolean getShaclTransactionMode() {
        try {
            this.verifyShaclPermissions(RoleActionType.READ, this.securityContext);
        }
        catch (ShaclBindException shaclBindException) {
            // empty catch block
        }
        return this.delegatee.getShaclTransactionMode();
    }

    public int size() throws UnreachableStoreException {
        return this.getAll().size();
    }

    public GraphQLSchema getGraphQlSchema() {
        return this.delegatee.getGraphQlSchema();
    }

    public SomlSchema getSomlSchema() {
        return this.delegatee.getSomlSchema();
    }

    private Rbac getRbac() {
        return this.rbacSchemaManager.getSomlSchema().getRbac();
    }

    public ShaclSchema getShaclSchema() {
        try {
            this.verifyShaclPermissions(RoleActionType.READ, this.securityContext);
        }
        catch (NoPermissionsException noper) {
            this.verifyShaclPermissions(RoleActionType.WRITE, this.securityContext);
        }
        return this.delegatee.getShaclSchema();
    }

    public Object getJsonLdFrame(String query) {
        return this.delegatee.getJsonLdFrame(query);
    }

    public Map<String, Object> getJsonLdContext() {
        return this.delegatee.getJsonLdContext();
    }

    public void reload() {
        this.delegatee.reload();
    }

    public void registerSchemaCreateListener(SchemaUpdateConsumer consumer) {
        this.delegatee.registerSchemaCreateListener(consumer);
    }

    public void registerSchemaChangeListener(SchemaUpdateConsumer consumer) {
        this.delegatee.registerSchemaChangeListener(consumer);
    }

    public void registerSchemaBindListener(SchemaUpdateConsumer consumer) {
        this.delegatee.registerSchemaBindListener(consumer);
    }

    public void registerSchemaRemovedListener(SchemaUpdateConsumer consumer) {
        this.delegatee.registerSchemaRemovedListener(consumer);
    }

    public Pair<OperationResponse, SomlSchema> validateSchema(String schema) {
        return this.delegatee.validateSchema(schema);
    }

    public Pair<OperationResponse, SomlSchema> validateSchema(String schema, boolean strict) {
        return this.delegatee.validateSchema(schema, strict);
    }

    public void validateSchemaBinding(SomlSchema somlSchema) {
        this.delegatee.validateSchemaBinding(somlSchema);
    }

    public boolean hasBoundSchema() throws UnreachableStoreException {
        return this.delegatee.hasBoundSchema();
    }

    public ShaclSchema revalidateShacl() {
        this.verifyShaclPermissions(RoleActionType.WRITE, this.securityContext);
        return this.delegatee.revalidateShacl();
    }

    public ShaclSchema rebindShacl() {
        this.verifyShaclPermissions(RoleActionType.WRITE, this.securityContext);
        return this.delegatee.rebindShacl();
    }

    public SomlSchemaManager useUnrestricted() {
        return this.delegatee;
    }

    public boolean rebindService() throws UnreachableStoreException {
        return this.delegatee.rebindService();
    }

    public String toString() {
        return "SecuredSomlSchemaManager{delegatee=" + String.valueOf(this.delegatee) + ", rbacSchemaManager=" + String.valueOf(this.rbacSchemaManager) + "}";
    }

    public HealthResult runHealthCheck() {
        HealthResult healthResult = this.delegatee != this.rbacSchemaManager ? HealthResult.combine(() -> ((SomlSchemaManager)this.delegatee).runHealthCheck(), () -> ((SomlSchemaManager)this.rbacSchemaManager).runHealthCheck()) : this.delegatee.runHealthCheck();
        healthResult.setName("secure-" + healthResult.getName());
        return healthResult;
    }
}

