/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions.soml;

import com.ontotext.models.Rbac;
import com.ontotext.models.SomlSchema;
import com.ontotext.rbac.RbacOptions;
import com.ontotext.rbac.models.extensions.SchemaRoleSupplier;
import com.ontotext.soaas.plugin.Inject;
import com.ontotext.soaas.plugin.Order;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Order(value=90)
public class AddSomlRbacAdminRole
extends SchemaRoleSupplier {
    private String rbacManagementRole = "SchemaRBACAdmin";

    public boolean canHandle(SomlSchema somlSchema) {
        return "/soml/soml-rbac".equals(somlSchema.getId());
    }

    @Override
    protected String role(Rbac rbac) {
        return this.rbacManagementRole;
    }

    @Override
    protected String roleDescription() {
        return "SOML RBAC administration role with full access";
    }

    @Override
    protected List<String> allowedActions() {
        return Collections.singletonList("*/*");
    }

    @Inject
    public void setValidatorOptions(RbacOptions somlRbacConfigurations) {
        this.rbacManagementRole = Objects.requireNonNullElse(StringUtils.trimToNull((String)somlRbacConfigurations.getRbacManagementRole()), "SchemaRBACAdmin");
    }
}

