/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.ontotext.models.RoleAction;
import com.ontotext.models.RoleActionType;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class RoleActionsParserBase
implements SchemaExtension {
    private static final int MAX_RBAC_FILTER_SPLIT_COUNT = 4;
    private static final String ACTION_SEPARATOR = "/";
    protected static final String WILDCARD = "*";
    protected static final Set<String> ACTION_TYPES = Arrays.stream(RoleActionType.values()).map(Enum::toString).collect(Collectors.toSet());

    public void process(SomlSchema somlSchema) {
        somlSchema.getRbac().getRoles().values().forEach(role -> {
            if (role != null) {
                role.getActions().forEach(this::parseAction);
                role.getNotActions().forEach(this::parseAction);
            }
        });
    }

    public void parseAction(RoleAction action) {
        String[] split;
        if (StringUtils.isNotBlank((CharSequence)action.getAction()) && this.isSyntaxValid(split = RoleActionsParserBase.splitAction(action.getAction()))) {
            this.initRoleAction(action, split);
        }
    }

    private static String[] splitAction(String action) {
        return action.split(ACTION_SEPARATOR, 4);
    }

    protected abstract boolean isSyntaxValid(String[] var1);

    protected abstract void initRoleAction(RoleAction var1, String[] var2);
}

