/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.ontotext.models.Rbac;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.rbac.models.extensions.SchemaRoleSupplier;
import java.util.Collections;
import java.util.List;

@Order(value=80)
public class AddDefaultRbacRole
extends SchemaRoleSupplier {
    public boolean canHandle(SomlSchema somlSchema) {
        return !"/soml/soml-rbac".equals(somlSchema.getId());
    }

    @Override
    protected String role(Rbac rbac) {
        return rbac.getContainedIn().getConfig().getDefaultRole().orElse("Default");
    }

    @Override
    protected String roleDescription() {
        return "Default role, which does not need to be declared. Restricts read, write and delete access.";
    }

    @Override
    protected List<String> notAllowedActions() {
        return Collections.singletonList("*/*/*");
    }
}

