/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.models.extensions;

import com.ontotext.models.Rbac;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.Order;
import com.ontotext.rbac.models.extensions.SchemaRoleSupplier;
import java.util.Collections;
import java.util.List;

@Order(value=79)
public class AddAdminRbacRole
extends SchemaRoleSupplier {
    private String adminRoleName;

    public boolean canHandle(SomlSchema somlSchema) {
        return !"/soml/soml-rbac".equals(somlSchema.getId());
    }

    @Override
    public void process(SomlSchema somlSchema) {
        this.adminRoleName = somlSchema.getConfig().getAdminRole().orElse(null);
        if (this.adminRoleName != null) {
            super.process(somlSchema);
        }
    }

    @Override
    protected String role(Rbac rbac) {
        return this.adminRoleName;
    }

    @Override
    protected String roleDescription() {
        return "Admin role, which grants read, write and delete access in a GraphQL endpoint.";
    }

    @Override
    protected List<String> allowedActions() {
        return Collections.singletonList("*/*/*");
    }
}

