/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.jwt;

import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.UrlJwkProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.SigningKeyResolver;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;

public class RemoteJwkSigningKeyResolver
implements SigningKeyResolver {
    private final JwkProvider jwkProvider;

    public RemoteJwkSigningKeyResolver(String jwksUri) {
        this.jwkProvider = RemoteJwkSigningKeyResolver.create(jwksUri);
    }

    public Key resolveSigningKey(JwsHeader header, Claims claims) {
        return this.getKey(header.getKeyId());
    }

    public Key resolveSigningKey(JwsHeader header, byte[] bytes) {
        return this.getKey(header.getKeyId());
    }

    private Key getKey(String id) {
        try {
            return this.jwkProvider.get(id).getPublicKey();
        }
        catch (JwkException exc) {
            throw new IllegalArgumentException("unable to resolve jwk", exc);
        }
    }

    private static JwkProvider create(String jwksUri) {
        try {
            return new UrlJwkProvider(new URL(jwksUri));
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException("Invalid jwks uri", exc);
        }
    }
}

