/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.jwt;

import com.ontotext.rbac.jwt.JwtClaimMapping;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class JwtGenerator {
    private static final int TOKEN_EXPIRATION_TIME = 0x6DDD00;
    private final String secret;
    private final JwtClaimMapping jwtClaims;

    public JwtGenerator() {
        this(null, null);
    }

    public JwtGenerator(String secret) {
        this(secret, null);
    }

    public JwtGenerator(String secret, JwtClaimMapping jwtClaims) {
        this.secret = StringUtils.hasText((String)secret) ? secret : null;
        this.jwtClaims = jwtClaims == null ? JwtClaimMapping.DEFAULTS : jwtClaims;
    }

    public String generateToken(String username) {
        return this.createToken(new HashMap<String, Object>(1), username);
    }

    public String generateToken(String username, Map<String, Object> claims) {
        return this.createToken(claims, username);
    }

    public JwtBuilder createTokenBuilder(Map<String, Object> claims, String subject) {
        return ((JwtBuilder)((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setClaims(claims).setSubject(subject)).claim(this.jwtClaims.getUsernameClaim(), (Object)subject).setIssuedAt(new Date(System.currentTimeMillis()))).setNotBefore(new Date(System.currentTimeMillis()))).setExpiration(new Date(System.currentTimeMillis() + 0x6DDD00L))).signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret.getBytes(StandardCharsets.UTF_8)), SignatureAlgorithm.HS256);
    }

    private String createToken(Map<String, Object> claims, String subject) {
        return this.createTokenBuilder(claims, subject).compact();
    }
}

