/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rbac.jwt;

import com.ontotext.rbac.jwt.JwtClaimMapping;
import io.jsonwebtoken.Claims;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class Jwt {
    private final Claims claims;
    private final JwtClaimMapping claimMapping;

    public Jwt(Claims claims, JwtClaimMapping claimMapping) {
        this.claims = claims;
        this.claimMapping = claimMapping;
    }

    public String getUsername() {
        return (String)this.claims.get(this.getClaimMapping().getUsernameClaim(), String.class);
    }

    public Optional<Collection<String>> getRoles() {
        return Optional.ofNullable(this.getRolesClaim());
    }

    private Collection<String> getRolesClaim() {
        Object roleValue = this.claims.get((Object)this.getClaimMapping().getRolesClaim());
        if (roleValue instanceof String) {
            return Collections.singletonList((String)roleValue);
        }
        return (Collection)this.claims.get(this.getClaimMapping().getRolesClaim(), Collection.class);
    }

    public JwtClaimMapping getClaimMapping() {
        return this.claimMapping;
    }

    public Claims getClaims() {
        return this.claims;
    }

    public <T> T getClaimValue(String mappingKey, String defaultClaimKey, Class<? extends T> claimType) {
        return (T)this.getClaims().get(this.getClaimMapping().getOrDefault(mappingKey, defaultClaimKey), claimType);
    }
}

