/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.AbstractSparqlRequest;
import com.ontotext.sparql.SparqlConnection;
import java.util.UUID;
import java.util.regex.Pattern;

public class UpdateRequest
extends AbstractSparqlRequest<String, UpdateRequest> {
    private static final Pattern UPDATE_PATTERN = Pattern.compile("\\b(?:(?:[Dd][Ee][Ll][Ee][Tt][Ee])|(?:[Ii][Nn][Ss][Ee][Rr][Tt]))\\b");
    private final String query;

    public UpdateRequest(String requestId, String query) {
        super(requestId);
        this.query = query;
    }

    public static UpdateRequest newSimpleRequest(String update) {
        return new UpdateRequest(UUID.randomUUID().toString(), update);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public static boolean isUpdate(String query) {
        return UPDATE_PATTERN.matcher(query).find();
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        if (UpdateRequest.isUpdate(this.query)) {
            return (E)connection.executeUpdate(this);
        }
        throw new UnsupportedOperationException("Only INSERT and DELETE queries are supported!");
    }
}

