/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.TransactionControlRequest;

public class TransactionRollbackRequest
extends TransactionControlRequest {
    public TransactionRollbackRequest(String requestId) {
        super(requestId);
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        if (!connection.isTxActive()) {
            return (E)ExecutionResponse.ofError((String)this.getRequestId(), (Throwable)new RuntimeException("Cannot rollback transaction already committed transaction for request: " + this.getRequestId()));
        }
        try {
            Loggers.sparqlUpdateLogger().trace("Transaction rollback: {}", (Object)this.getRequestId());
            connection.rollback();
        }
        catch (RuntimeException re) {
            return (E)ExecutionResponse.ofError((String)this.getRequestId(), (Throwable)re);
        }
        return (E)ExecutionResponse.of(null, (String)this.getRequestId());
    }
}

