/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.TransactionControlRequest;

public class TransactionBeginRequest
extends TransactionControlRequest {
    private final String isolationLevel;

    public TransactionBeginRequest(String requestId) {
        this(requestId, null);
    }

    public TransactionBeginRequest(String requestId, String isolationLevel) {
        super(requestId);
        this.isolationLevel = isolationLevel;
    }

    @Override
    public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
        if (connection.isTxActive()) {
            return (E)ExecutionResponse.ofError((String)this.getRequestId(), (Throwable)new RuntimeException("Cannot begin transaction. Transaction already active for request: " + this.getRequestId()));
        }
        try {
            Loggers.sparqlUpdateLogger().trace("Transaction begin: {} with isolation level: {}", (Object)this.getRequestId(), (Object)this.isolationLevel);
            connection.begin(this.isolationLevel);
        }
        catch (RuntimeException re) {
            return (E)ExecutionResponse.ofError((String)this.getRequestId(), (Throwable)re);
        }
        return (E)ExecutionResponse.of(null, (String)this.getRequestId());
    }
}

