/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.AbstractTransactionPolicy;
import com.ontotext.sparql.ChainingTransactionControlRequest;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.TransactionControlRequest;
import com.ontotext.sparql.TransactionPolicy;
import com.ontotext.sparql.UpdateRequest;

public class TrackChangesTransactionPolicy
extends AbstractTransactionPolicy {
    private final TransactionPolicy delegate;

    public TrackChangesTransactionPolicy(TransactionPolicy delegate) {
        this.delegate = delegate;
    }

    @Override
    public TransactionControlRequest onBeforeFirst(String requestId) {
        return this.delegate.onBeforeFirst(requestId);
    }

    @Override
    public TransactionControlRequest onAfterLast(String requestId) {
        return this.delegate.onAfterLast(requestId);
    }

    @Override
    public TransactionControlRequest onError(String requestId, Throwable rollbackCause) {
        return this.delegate.onError(requestId, rollbackCause);
    }

    @Override
    public boolean executeReadsInTx() {
        return this.delegate.executeReadsInTx();
    }

    @Override
    public TransactionControlRequest onRequestComplete(String requestId) {
        return this.delegate.onRequestComplete(requestId);
    }

    @Override
    public TransactionControlRequest onBeforeEach(String requestId) {
        TransactionControlRequest delegateRequest = this.delegate.onBeforeEach(requestId);
        if (delegateRequest == null) {
            return new StartChangesTracking(requestId);
        }
        return new ChainingTransactionControlRequest(requestId, delegateRequest, new StartChangesTracking(requestId));
    }

    @Override
    public TransactionControlRequest onAfterEach(String requestId) {
        return this.delegate.onAfterEach(requestId);
    }

    @Override
    public boolean rollBackOnSingleUpdateFailure() {
        return this.delegate.rollBackOnSingleUpdateFailure();
    }

    private static class StartChangesTracking
    extends TransactionControlRequest {
        private static final String TRACK_CHANGES = "insert data { [] <http://www.ontotext.com/track-changes> \"%s\" }";

        StartChangesTracking(String requestId) {
            super(requestId);
        }

        @Override
        public <R, E extends ExecutionResponse<R>> E execute(SparqlConnection connection) {
            UpdateRequest updateRequest = new UpdateRequest(this.getRequestId(), StartChangesTracking.getTrackChangesQuery(this.getRequestId()));
            if (!this.logRequest()) {
                updateRequest.disableRequestLogging();
            }
            return updateRequest.execute(connection);
        }

        private static String getTrackChangesQuery(String requestId) {
            return String.format(TRACK_CHANGES, requestId);
        }
    }
}

