/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import com.ontotext.sparql.UpdateRequest;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TrackChangesRemover {
    private static final String DELETE_CHANGES = "insert data { [] <http://www.ontotext.com/delete-changes> %s }";

    public Optional<Serializable> removeChanges(String requestId, List<String> requestIds, SomlSchema schema, SparqlEndpoint endpoint, SparqlQueryInvoker invoker) {
        UpdateRequest deleteChangesRequest = this.createDeleteChangesRequest(requestId, requestIds);
        ExecutionResponse response = invoker.invoke(deleteChangesRequest, endpoint);
        if (response.getError() != null) {
            return Optional.of(response.getError().getMessage());
        }
        return Optional.empty();
    }

    private UpdateRequest createDeleteChangesRequest(String requestId, List<String> requestIds) {
        String ids = requestIds.stream().distinct().collect(Collectors.joining("\", \"", "\"", "\""));
        String deleteChangesQuery = String.format(DELETE_CHANGES, ids);
        return (UpdateRequest)new UpdateRequest(requestId, deleteChangesQuery).disableRequestLogging();
    }
}

