/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.sparql.AddressManager;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlClusterConfigurations {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int LEADER_DISCOVERY_RETRIES_DEFAULT = 1;
    public static final int CLUSTER_STATUS_TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(15L);
    public static final int CLUSTER_STATUS_CONNECT_TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(5L);
    public static final int LEADER_DISCOVERY_RETRY_DELAY_DEFAULT = (int)TimeUnit.SECONDS.toMillis(5L);
    public static final int LEADER_OPERATION_RETRIES_DEFAULT = 1;
    private boolean forceConnection = false;
    private boolean forceClusterClient = false;
    private int leaderDiscoveryRetries = 1;
    private int clusterStatusTimeout = CLUSTER_STATUS_TIMEOUT_DEFAULT;
    private int clusterStatusConnectTimeout = CLUSTER_STATUS_CONNECT_TIMEOUT_DEFAULT;
    private int leaderDiscoveryRetryDelay = LEADER_DISCOVERY_RETRY_DELAY_DEFAULT;
    private int leaderOperationRetries = 1;
    private boolean concurrentStatusCheck = true;
    private ExecutorService executorService;
    private AddressManager addressManager;

    public SparqlClusterConfigurations() {
    }

    public SparqlClusterConfigurations(SparqlClusterConfigurations copyFrom) {
        Objects.requireNonNull(copyFrom, "Source configuration is required");
        this.forceConnection = copyFrom.forceConnection;
        this.forceClusterClient = copyFrom.forceClusterClient;
        this.leaderDiscoveryRetries = copyFrom.leaderDiscoveryRetries;
        this.clusterStatusTimeout = copyFrom.clusterStatusTimeout;
        this.clusterStatusConnectTimeout = copyFrom.clusterStatusConnectTimeout;
        this.leaderDiscoveryRetryDelay = copyFrom.leaderDiscoveryRetryDelay;
        this.leaderOperationRetries = copyFrom.leaderOperationRetries;
        this.concurrentStatusCheck = copyFrom.concurrentStatusCheck;
        this.executorService = copyFrom.executorService;
        this.addressManager = copyFrom.addressManager;
    }

    public boolean isForceConnection() {
        return this.forceConnection;
    }

    public void setForceConnection(boolean forceConnection) {
        this.forceConnection = forceConnection;
    }

    public void setForceClusterClient(boolean forceClusterClient) {
        this.forceClusterClient = forceClusterClient;
    }

    public boolean isForceClusterClient() {
        return this.forceClusterClient;
    }

    public int getLeaderDiscoveryRetries() {
        return this.leaderDiscoveryRetries;
    }

    public void setLeaderDiscoveryRetries(int leaderDiscoveryRetries) {
        this.leaderDiscoveryRetries = leaderDiscoveryRetries;
    }

    public int getClusterStatusTimeout() {
        return this.clusterStatusTimeout;
    }

    public void setClusterStatusTimeout(int clusterStatusTimeout) {
        this.clusterStatusTimeout = clusterStatusTimeout;
    }

    public int getClusterStatusConnectTimeout() {
        return this.clusterStatusConnectTimeout;
    }

    public void setClusterStatusConnectTimeout(int clusterStatusConnectTimeout) {
        this.clusterStatusConnectTimeout = clusterStatusConnectTimeout;
    }

    public int getLeaderDiscoveryRetryDelay() {
        return this.leaderDiscoveryRetryDelay;
    }

    public void setLeaderDiscoveryRetryDelay(int leaderDiscoveryRetryDelay) {
        this.leaderDiscoveryRetryDelay = leaderDiscoveryRetryDelay;
    }

    public int getLeaderOperationRetries() {
        return this.leaderOperationRetries;
    }

    public void setLeaderOperationRetries(int leaderOperationRetries) {
        this.leaderOperationRetries = leaderOperationRetries;
    }

    public boolean isConcurrentStatusCheck() {
        return this.concurrentStatusCheck;
    }

    public void setConcurrentStatusCheck(boolean concurrentStatusCheck) {
        this.concurrentStatusCheck = concurrentStatusCheck;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public AddressManager getAddressManager() {
        return this.addressManager;
    }

    public void setAddressManager(AddressManager addressManager) {
        this.addressManager = addressManager;
    }

    public String toString() {
        return "[forceConnection=" + this.forceConnection + ", leaderDiscoveryRetries=" + this.leaderDiscoveryRetries + ", clusterStatusTimeout=" + this.clusterStatusTimeout + ", clusterStatusConnectTimeout=" + this.clusterStatusConnectTimeout + ", leaderDiscoveryRetryDelay=" + this.leaderDiscoveryRetryDelay + ", leaderOperationRetries=" + this.leaderOperationRetries + ", concurrentStatusCheck=" + this.concurrentStatusCheck + "}";
    }

    @Deprecated
    public void setUnavailableReadTimeout(long unavailableReadTimeout) {
        LOGGER.warn("sparql.endpoint.cluster.unavailableReadTimeout configurations is no longer used!");
    }

    @Deprecated
    public void setUnavailableWriteTimeout(long unavailableWriteTimeout) {
        LOGGER.warn("sparql.endpoint.cluster.unavailableWriteTimeout configurations is no longer used!");
    }

    @Deprecated
    public void setScanFailedInterval(long scanFailedInterval) {
        LOGGER.warn("sparql.endpoint.cluster.retryOnHttp4xx configurations is no longer used!");
    }

    @Deprecated
    public void setRetryOnHttp4xx(boolean retryOnHttp4xx) {
        LOGGER.warn("sparql.endpoint.cluster.retryOnHttp4xx configurations is no longer used!");
    }

    @Deprecated
    public void setRetryOnHttp5xx(boolean retryOnHttp5xx) {
        LOGGER.warn("sparql.endpoint.cluster.retryOnHttp5xx configurations is no longer used!");
    }
}

