/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;
import org.jetbrains.annotations.NotNull;

public class SinglePropertyResultHandler
extends AbstractTupleQueryResultHandler {
    private final String bindingName;
    private final int limit;
    private int count = 0;
    private List<Value> results;

    public SinglePropertyResultHandler(String bindingName) {
        this.bindingName = bindingName;
        this.limit = -1;
        this.results = new LinkedList<Value>();
    }

    public SinglePropertyResultHandler(String bindingName, int limit) {
        this.bindingName = bindingName;
        this.limit = limit;
        this.results = new ArrayList<Value>(limit);
    }

    public void startQueryResult(List<String> bindingNames) {
        super.startQueryResult(bindingNames);
        this.count = 0;
    }

    public void handleSolution(BindingSet bindingSet) {
        if (this.limit > 0 && this.count == this.limit) {
            return;
        }
        Value value = bindingSet.getValue(this.bindingName);
        if (value != null) {
            this.results.add(value);
            ++this.count;
        }
    }

    public List<Value> getResults() {
        return this.results;
    }

    public List<Value> getDistinctResults() {
        return this.results.stream().distinct().toList();
    }

    public List<IRI> getAsIri() {
        return this.getResultsAs(IRI.class, LinkedList::new);
    }

    public Set<IRI> getAsDistinctIri() {
        return this.getResultsAs(IRI.class, LinkedHashSet::new);
    }

    public List<Literal> getAsLiteral() {
        return this.getResultsAs(Literal.class, LinkedList::new);
    }

    public Set<Literal> getAsDistinctLiteral() {
        return this.getResultsAs(Literal.class, LinkedHashSet::new);
    }

    @NotNull
    public <T, C extends Collection<T>> C getResultsAs(Class<T> type, Supplier<C> supplier) {
        return (C)((Collection)this.getResults().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toCollection(supplier)));
    }
}

