/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.models.Prefixes;
import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.rdf.CardinalityAwareBindingDescriptor;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfPath;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.ValueReader;
import com.ontotext.sparql.Rdf4jValueConverter;
import it.unimi.dsi.fastutil.longs.Long2LongArrayMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.factory.map.primitive.MutableLongObjectMapFactory;
import org.eclipse.collections.api.factory.set.primitive.MutableLongSetFactory;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.LongLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongLongPair;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongLongMaps;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class RdfDataTupleResultHandler
extends AbstractTupleQueryResultHandler {
    private static final Logger LOGGER = Loggers.sparqlQueryResultsLogger();
    private Consumer<Object> logHandle = RdfDataTupleResultHandler.configureLogging();
    private static final String SO_NAME = "http://www.ontotext.com/semantic-object/name";
    private static final MutableLongObjectMap<MutableLongObjectMap<MutableLongSet>> EMPTY_MAP_INSTANCE = LongObjectMaps.mutable.empty();
    private static final Function0<MutableLongObjectMap<MutableLongObjectMap<MutableLongSet>>> EMPTY_MAP = (Function0 & Serializable)() -> EMPTY_MAP_INSTANCE;
    private static final MutableLongObjectMap<MutableLongSet> EMPTY_MAP_TO_SET_INSTANCE = LongObjectMaps.mutable.empty();
    private static final Function0<MutableLongObjectMap<MutableLongSet>> EMPTY_MAP_TO_SET = (Function0 & Serializable)() -> EMPTY_MAP_TO_SET_INSTANCE;
    private static final MutableLongSet EMPTY_SET_INSTANCE = LongSets.mutable.empty();
    private static final Function0<MutableLongSet> EMPTY_SET = (Function0 & Serializable)() -> EMPTY_SET_INSTANCE;
    private final Prefixes prefixes;
    private final EntityPool pool = EntityPoolFactory.defaultPool();
    private RdfTree rdfTree;
    private final LongCardinalityAwareBindingDescriptor bindingNames;
    private final ObjectSet<LongList> multiValuedPaths;
    private final boolean interpolateTupleResults;
    private final LongSet intermediateBindingNames;
    private MutableLongObjectMap<MutableLongObjectMap<MutableLongSet>> lastKnownBindingValues;
    private MutableLongObjectMap<MutableLongObjectMap<MutableLongObjectMap<MutableLongSet>>> lastKnownChildValues;
    private UnifiedSet<LongList> alreadyInsertedPaths;
    private boolean enableCartesianProtection = false;

    public RdfDataTupleResultHandler(SomlSchema somlSchema, Map<String, List<String>> bindings, boolean interpolateTupleResults) {
        this.prefixes = Objects.requireNonNull(somlSchema, "SomlSchema mapping is required").getPrefixes();
        this.bindingNames = this.convertPartsToIri(bindings);
        this.interpolateTupleResults = interpolateTupleResults;
        this.intermediateBindingNames = this.createIntermediateBindingNames();
        this.multiValuedPaths = this.collectMultiValuedPaths();
        this.lastKnownBindingValues = LongObjectMaps.mutable.empty();
        this.lastKnownChildValues = LongObjectMaps.mutable.empty();
        this.alreadyInsertedPaths = new UnifiedSet();
    }

    private ObjectOpenHashSet<LongList> collectMultiValuedPaths() {
        return (ObjectOpenHashSet)this.bindingNames.keyValuesView().asLazy().select((org.eclipse.collections.api.block.predicate.Predicate & Serializable)each -> this.bindingNames.isMultiValued(each.getOne()) && ((BindingEntry)each.getTwo()).getPath().size() > 1).collect((Function & Serializable)each -> ((BindingEntry)each.getTwo()).getPath()).reduceInPlace(ObjectOpenHashSet::new, ObjectOpenHashSet::add);
    }

    private LongSet createIntermediateBindingNames() {
        MutableLongSet nodeBindings = LongSets.mutable.empty();
        block0: for (LongObjectPair bindingEntry : this.bindingNames.keyValuesView()) {
            long binding = bindingEntry.getOne();
            for (LongObjectPair otherBindingEntry : this.bindingNames.keyValuesView()) {
                if (binding == otherBindingEntry.getOne() || !this.isSubBindingOf(binding, otherBindingEntry.getOne()) || !this.containsAll(((BindingEntry)otherBindingEntry.getTwo()).getPath(), ((BindingEntry)bindingEntry.getTwo()).getPath())) continue;
                nodeBindings.add(binding);
                continue block0;
            }
        }
        return nodeBindings;
    }

    private boolean isSubBindingOf(long binding, long otherBinding) {
        String parent = this.pool.getString(binding);
        String child = this.pool.getString(otherBinding);
        return child.startsWith(parent);
    }

    private boolean containsAll(LongList target, LongList toMatch) {
        if (toMatch.size() > target.size()) {
            return false;
        }
        for (int i = 0; i < toMatch.size(); ++i) {
            if (Objects.equals(target.get(i), toMatch.get(i))) continue;
            return false;
        }
        return true;
    }

    private LongCardinalityAwareBindingDescriptor convertPartsToIri(Map<String, List<String>> bindings) {
        LongCardinalityAwareBindingDescriptor descriptor = new LongCardinalityAwareBindingDescriptor(bindings.size());
        Predicate<String> cardinalityChecker = RdfDataTupleResultHandler.getCardinalityChecker(this.prefixes, bindings);
        bindings.forEach((binding, paths) -> descriptor.put(this.pool.resolve(binding), (LongList)LongLists.mutable.of(paths.stream().map(arg_0 -> ((Prefixes)this.prefixes).nameToShortIri(arg_0)).map(arg_0 -> ((Prefixes)this.prefixes).toIri(arg_0)).mapToLong(arg_0 -> ((EntityPool)this.pool).resolve(arg_0)).toArray()), cardinalityChecker.test((String)binding), (String)paths.get(0)));
        descriptor.computeNextBindings();
        return descriptor;
    }

    @NotNull
    private static Predicate<String> getCardinalityChecker(Prefixes prefixes, Map<String, List<String>> bindings) {
        Predicate<String> cardinalityChecker = key -> true;
        if (bindings instanceof CardinalityAwareBindingDescriptor) {
            cardinalityChecker = name -> {
                if (((CardinalityAwareBindingDescriptor)bindings).isMultiValued(name)) {
                    return true;
                }
                List path = (List)bindings.get(name);
                String bindingName = (String)path.get(path.size() - 1);
                return SO_NAME.equals(prefixes.toIri(prefixes.nameToShortIri(bindingName)));
            };
        }
        return cardinalityChecker;
    }

    public void startQueryResult(List<String> bindingNames) {
        boolean extraBindings;
        this.logHandle = RdfDataTupleResultHandler.configureLogging();
        MutableSet names = this.bindingNames.keysView().collect(arg_0 -> ((EntityPool)this.pool).getString(arg_0)).toSet();
        boolean missingBindings = !names.containsAll(bindingNames);
        boolean bl = extraBindings = !bindingNames.containsAll((Collection<?>)names);
        if (missingBindings || extraBindings) {
            if (missingBindings && extraBindings) {
                throw new TupleQueryResultHandlerException("Configured binding names does not match! Expected " + String.valueOf(names) + ", got " + String.valueOf(bindingNames));
            }
            LOGGER.warn("Configured binding names does not match! Expected {}, got {}", (Object)names, bindingNames);
        }
        this.rdfTree = this.pool.emptyTree();
        this.rdfTree.setValueReader((ValueReader)Rdf4jValueConverter.INSTANCE);
    }

    public void handleSolution(BindingSet bindingSet) {
        this.logHandle.accept(bindingSet);
        if (bindingSet.size() == 0) {
            return;
        }
        List<RdfPath> rdfPaths = this.bindingSetToPaths(bindingSet);
        for (RdfPath rdfPath : rdfPaths) {
            if (rdfPath.isWildCardPath()) {
                this.toRelativePath(rdfPath, arg_0 -> ((RdfTree)this.rdfTree).add(arg_0));
                continue;
            }
            int values = this.rdfTree.add(rdfPath);
            this.checkForCartesianProduct(rdfPath, values);
        }
    }

    private void checkForCartesianProduct(RdfPath rdfPath, int values) {
        if (!this.isEnableCartesianProtection() || values <= 1 || rdfPath.depth() < 2) {
            return;
        }
        RdfPath tail = rdfPath.tail();
        LongList bindingPath = this.createBindingPath(tail);
        if (!this.multiValuedPaths.contains((Object)bindingPath)) {
            throw new TupleQueryResultHandlerException("Found multiple values for a property defined as single-valued. Offending triple: " + String.valueOf(tail.trimHead()));
        }
    }

    private void toRelativePath(RdfPath rdfPath, Consumer<RdfPath> pathConsumer) {
        RdfPath path = rdfPath.head();
        while (path.isWildCardNode() && path.hasNext()) {
            path = path.next();
        }
        long bindingId = this.getBindingName(path.hasPrevious() ? path.previous() : path);
        String queryName = this.pool.getString(bindingId);
        if (!(path = path.trimHead()).isWildCardPath()) {
            pathConsumer.accept(this.pool.toPath("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + queryName, this.pool.get(path.getSubject())).append(path));
        } else {
            pathConsumer.accept(this.pool.toPath("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + queryName, this.pool.get(path.getObject())));
        }
    }

    private List<RdfPath> bindingSetToPaths(BindingSet bindingSet) {
        LinkedList<RdfPath> rdfPaths = new LinkedList<RdfPath>();
        ArrayList<LongLongPair> intermediateBindings = new ArrayList<LongLongPair>(this.intermediateBindingNames.size());
        MutableLongSet importantBinding = LongSets.mutable.empty();
        LongLongMap bindingsCopy = this.readBindings(bindingSet, intermediateBindings, importantBinding);
        if (intermediateBindings.size() > 1) {
            this.collectLastKnownBindingValues(intermediateBindings);
        }
        RdfPath rdfPath = this.resolveImportantPaths(rdfPaths, (LongSet)importantBinding, bindingsCopy);
        if (importantBinding.isEmpty() && rdfPath != null) {
            rdfPaths.add(rdfPath);
        }
        return rdfPaths;
    }

    private RdfPath resolveImportantPaths(List<RdfPath> rdfPaths, LongSet importantBinding, LongLongMap bindingsCopy) {
        RdfPath rdfPath = null;
        BiConsumer<Long, RdfPath> valueCollection = this.collectKnownValues().andThen((bindingName, path) -> rdfPaths.add((RdfPath)path));
        for (LongLongPair entry : bindingsCopy.keyValuesView()) {
            long bindingName2 = entry.getOne();
            LongList path2 = this.bindingNames.getBindingPath(bindingName2);
            RdfPath tmp = this.addValueToPath(bindingName2, entry.getTwo(), path2, rdfPath);
            if (importantBinding.contains(bindingName2)) {
                if (tmp.isWildCardPath()) {
                    Stream<RdfPath> rdfPathStream = this.convertWildCardPathToRealPaths(tmp);
                    rdfPathStream.forEach(each -> valueCollection.accept(bindingName2, (RdfPath)each));
                } else {
                    valueCollection.accept(bindingName2, tmp);
                }
                if (this.intermediateBindingNames.contains(bindingName2)) {
                    rdfPath = tmp;
                }
            } else {
                rdfPath = tmp;
            }
            if (!this.interpolateTupleResults) continue;
            this.collectKnownValues().accept(bindingName2, tmp);
            this.readPassedProperties(tmp, bindingName2, entry.getTwo(), rdfPaths);
        }
        this.collectLastKnownPath(importantBinding, rdfPath, eachPath -> valueCollection.accept(0L, (RdfPath)eachPath));
        return rdfPath;
    }

    private void collectLastKnownPath(LongSet importantBinding, RdfPath rdfPath, Consumer<RdfPath> valueCollection) {
        if (importantBinding.isEmpty() && rdfPath != null && rdfPath.isWildCardPath()) {
            this.convertWildCardPathToRealPaths(rdfPath).forEach(valueCollection);
        }
    }

    private void readPassedProperties(RdfPath tmp, long bindingName, long childId, List<RdfPath> rdfPaths) {
        MutableLongObjectMap properties = (MutableLongObjectMap)((MutableLongObjectMap)this.lastKnownChildValues.getIfAbsent(bindingName, EMPTY_MAP)).getIfAbsent(childId, EMPTY_MAP_TO_SET);
        if (properties.isEmpty()) {
            return;
        }
        if (tmp.isWildCardPath()) {
            this.convertWildCardPathToRealPaths(tmp).forEach(resolvedPath -> this.readSubProperties(bindingName, (RdfPath)resolvedPath, (MutableLongObjectMap<MutableLongSet>)properties, rdfPaths::add));
        }
    }

    private void readSubProperties(long bindingName, RdfPath path, MutableLongObjectMap<MutableLongSet> properties, Consumer<RdfPath> pathConsumer) {
        for (LongObjectPair entry : properties.keyValuesView()) {
            long property = entry.getOne();
            MutableLongSet values = (MutableLongSet)entry.getTwo();
            long subBinding = this.bindingNames.getNextBinding(bindingName, property);
            MutableLongObjectMap subBindingValue = (MutableLongObjectMap)this.lastKnownChildValues.get(subBinding);
            if (subBindingValue == null) {
                values.forEach((LongProcedure & Serializable)value -> {
                    RdfPath newRdfPath = path.add(property, value);
                    LongList key = this.createBindingPath(newRdfPath);
                    if (this.alreadyInsertedPaths.contains((Object)key)) {
                        return;
                    }
                    this.alreadyInsertedPaths.add((Object)key);
                    pathConsumer.accept(newRdfPath);
                });
                continue;
            }
            MutableLongIterator it = values.longIterator();
            while (it.hasNext()) {
                long value2 = it.next();
                RdfPath subPath = path.add(property, value2);
                MutableLongObjectMap subProperties = (MutableLongObjectMap)subBindingValue.getIfAbsent(value2, EMPTY_MAP_TO_SET);
                this.readSubProperties(subBinding, subPath, (MutableLongObjectMap<MutableLongSet>)subProperties, pathConsumer);
            }
        }
    }

    private BiConsumer<Long, RdfPath> collectKnownValues() {
        return (endBinding, path) -> {
            if (!this.interpolateTupleResults) {
                return;
            }
            RdfPath tail = path.tail();
            if (!tail.hasPrevious() || tail.getSubject() == 0L) {
                return;
            }
            if (endBinding == 0L) {
                endBinding = this.getBindingName(tail);
            }
            if (!this.intermediateBindingNames.contains(endBinding.longValue())) {
                return;
            }
            long bindingName = this.bindingNames.getPreviousBinding((long)endBinding);
            ((MutableLongSet)((MutableLongObjectMap)((MutableLongObjectMap)this.lastKnownChildValues.getIfAbsentPut(bindingName, () -> ((MutableLongObjectMapFactory)LongObjectMaps.mutable).empty())).getIfAbsentPut(tail.getSubject(), () -> ((MutableLongObjectMapFactory)LongObjectMaps.mutable).empty())).getIfAbsentPut(tail.getPredicate(), () -> ((MutableLongSetFactory)LongSets.mutable).empty())).add(tail.getObject());
        };
    }

    private void collectLastKnownBindingValues(List<LongLongPair> intermediateBindings) {
        if (intermediateBindings.size() < 2) {
            return;
        }
        intermediateBindings.sort(Comparator.comparingLong(LongLongPair::getOne));
        LongLongPair parent = this.removeFirstElement(intermediateBindings);
        LongLongPair child = null;
        do {
            if (child == null) {
                child = this.removeFirstElement(intermediateBindings);
            } else {
                LongLongPair next = this.removeFirstElement(intermediateBindings);
                if (this.isNextBindingChildOf(next.getOne(), child.getOne())) {
                    parent = child;
                    child = next;
                } else if (this.isNextBindingChildOf(next.getOne(), parent.getOne())) {
                    child = next;
                }
            }
            ((MutableLongSet)((MutableLongObjectMap)this.lastKnownBindingValues.getIfAbsentPut(child.getOne(), () -> ((MutableLongObjectMapFactory)LongObjectMaps.mutable).empty())).getIfAbsentPut(child.getTwo(), () -> ((MutableLongSetFactory)LongSets.mutable).empty())).add(parent.getTwo());
        } while (!intermediateBindings.isEmpty());
    }

    private boolean isNextBindingChildOf(long next, long previous) {
        return this.bindingNames.getPreviousBinding(next) == previous;
    }

    private LongLongPair removeFirstElement(List<LongLongPair> intermediateBindings) {
        return intermediateBindings.remove(0);
    }

    private LongLongMap readBindings(BindingSet bindingSet, Collection<LongLongPair> intermediateBindings, MutableLongSet importantBinding) {
        Long2ObjectRBTreeMap bindingCopy = new Long2ObjectRBTreeMap();
        bindingSet.forEach(arg_0 -> this.lambda$readBindings$8((Long2ObjectSortedMap)bindingCopy, arg_0));
        MutableLongLongMap bindings = LongLongMaps.mutable.ofInitialCapacity(this.bindingNames.size());
        for (Long2ObjectMap.Entry bindingEntry : bindingCopy.long2ObjectEntrySet()) {
            long bindingName = bindingEntry.getLongKey();
            Value value = (Value)bindingEntry.getValue();
            if (value == null) continue;
            boolean isIntermediate = this.intermediateBindingNames.contains(bindingName);
            if (isIntermediate && this.isNodeId(value)) {
                long iri = this.pool.resolve((Object)Rdf4jValueConverter.convert(value).toString());
                intermediateBindings.add(PrimitiveTuples.pair((long)bindingName, (long)iri));
            } else {
                importantBinding.add(bindingName);
            }
            long id = this.isNodeId(value) ? this.pool.resolve((Object)Rdf4jValueConverter.convert(value).toString()) : this.pool.resolve((Object)value);
            bindings.put(bindingName, id);
        }
        int readCount = bindingCopy.size();
        if (readCount > 0 && readCount != this.bindingNames.size()) {
            this.elevateBindingPriorityIfNeeded((Long2ObjectSortedMap<Value>)bindingCopy, importantBinding);
        }
        return bindings;
    }

    private void elevateBindingPriorityIfNeeded(Long2ObjectSortedMap<Value> bindingCopy, MutableLongSet importantBinding) {
        ObjectBidirectionalIterator it = bindingCopy.long2ObjectEntrySet().iterator();
        Long2ObjectMap.Entry previous = null;
        while (it.hasNext()) {
            if (previous == null) {
                previous = (Long2ObjectMap.Entry)it.next();
                continue;
            }
            Long2ObjectMap.Entry next = (Long2ObjectMap.Entry)it.next();
            long nextPrevious = this.bindingNames.getPreviousBinding(next.getLongKey());
            if (previous.getLongKey() != nextPrevious) {
                importantBinding.add(next.getLongKey());
            }
            previous = next;
        }
        importantBinding.add(bindingCopy.lastLongKey());
    }

    private boolean isNodeId(Value value) {
        return value instanceof IRI || value instanceof BNode;
    }

    private Stream<RdfPath> convertWildCardPathToRealPaths(RdfPath rdfPath) {
        RdfPath cursor = rdfPath.tail();
        while (cursor.hasPrevious() && !cursor.isWildCardNode()) {
            cursor = cursor.previous();
        }
        Stream.Builder<RdfPath> builder = Stream.builder();
        this.convertWildCardPathToRealPaths(cursor, cursor.getObject(), builder);
        return builder.build();
    }

    private void convertWildCardPathToRealPaths(RdfPath cursor, long lastKnownChildValue, Stream.Builder<RdfPath> builder) {
        if (!cursor.hasPrevious()) {
            return;
        }
        LongSet parents = this.resolveParentValuesForCursor(cursor, lastKnownChildValue);
        RdfPath fixedRestOfThePath = null;
        if (parents.isEmpty()) {
            builder.accept(cursor);
            return;
        }
        if (cursor.hasNext()) {
            RdfPath restOfThePath;
            fixedRestOfThePath = restOfThePath = cursor.next().trimHead();
            if (restOfThePath.isWildCardNode() && restOfThePath.hasNext()) {
                fixedRestOfThePath = this.pool.toPath(lastKnownChildValue, restOfThePath.getPredicate(), restOfThePath.getObject()).append(restOfThePath.next().trimHead());
            }
        }
        LongIterator it = parents.longIterator();
        while (it.hasNext()) {
            RdfPath previous;
            long parent = it.next();
            RdfPath fixedCurrentNode = this.pool.toPath(parent, cursor.getPredicate(), lastKnownChildValue);
            if (fixedRestOfThePath != null) {
                fixedCurrentNode = fixedCurrentNode.append(fixedRestOfThePath);
            }
            RdfPath newCursor = !(previous = cursor.previous()).hasPrevious() ? this.pool.toPath(previous.getSubject(), previous.getPredicate(), parent) : previous.trimTail();
            if (!(newCursor = newCursor.append(fixedCurrentNode)).previous().hasPrevious()) {
                builder.accept(newCursor);
                continue;
            }
            this.convertWildCardPathToRealPaths(newCursor.previous(), parent, builder);
        }
    }

    private LongSet resolveParentValuesForCursor(RdfPath cursor, long currentChildId) {
        long bindingName = this.getBindingName(cursor);
        MutableLongObjectMap childValues = (MutableLongObjectMap)this.lastKnownBindingValues.get(bindingName);
        if (childValues == null) {
            return EMPTY_SET_INSTANCE;
        }
        return (LongSet)childValues.getIfAbsent(currentChildId, EMPTY_SET);
    }

    private long getBindingName(RdfPath node) {
        LongList path;
        long binding;
        RdfPath current = node;
        while ((binding = this.bindingNames.getBinding(path = this.createBindingPath(current))) == 0L && (current = current.next()) != null) {
        }
        return binding;
    }

    private LongList createBindingPath(RdfPath node) {
        return (LongList)node.reduce((Object)LongLists.mutable.withInitialCapacity(node.previousCount() + 1), (rdfPath, predicates) -> {
            long predicate = rdfPath.getPredicate();
            if (predicates.isEmpty()) {
                predicate = this.bindingNames.remapResultPredicate(rdfPath.getPredicate(), this.prefixes, this.pool);
            }
            predicates.add(predicate);
            return predicates;
        }, rdfPath -> rdfPath != node);
    }

    private RdfPath addValueToPath(long bindingName, long value, LongList path, RdfPath previousPath) {
        String rootName = this.bindingNames.getBindingName(bindingName);
        if (path.size() == 1) {
            return this.pool.toPath("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + rootName, this.pool.get(value));
        }
        RdfPath parent = RdfDataTupleResultHandler.resolveParentPath(path, previousPath);
        RdfPath rdfPath = parent == null ? this.pool.toPath("http://www.ontotext.com/semantic-object/result/", "http://www.ontotext.com/semantic-object/result/" + rootName, null) : parent;
        for (int i = rdfPath.depth(); i < path.size() - 1; ++i) {
            rdfPath = rdfPath.add(path.get(i), 0L);
        }
        long lastNode = path.get(path.size() - 1);
        return rdfPath.add(lastNode, value);
    }

    private static RdfPath resolveParentPath(LongList path, RdfPath previousPath) {
        RdfPath parent = previousPath;
        if (previousPath != null && previousPath.depth() >= path.size()) {
            parent = parent.head().next();
            for (int i = 1; i < path.size(); ++i) {
                if (parent.getPredicate() != path.get(i)) {
                    parent = parent.previous().trimTail();
                    break;
                }
                if (!parent.hasNext()) {
                    throw new IllegalStateException(String.format("Current LongRdfPath (%s) depth and binding path (%s) differ somehow", parent.tail(), path));
                }
                parent = parent.next();
            }
        }
        return parent;
    }

    public void endQueryResult() {
        this.lastKnownBindingValues.clear();
        this.lastKnownBindingValues = null;
        this.lastKnownChildValues.clear();
        this.lastKnownChildValues = null;
        this.alreadyInsertedPaths.clear();
        this.alreadyInsertedPaths = null;
    }

    public boolean isEnableCartesianProtection() {
        return this.enableCartesianProtection;
    }

    public void setEnableCartesianProtection(boolean enableCartesianProtection) {
        this.enableCartesianProtection = enableCartesianProtection;
    }

    public RdfTree getRdfTree() {
        return this.rdfTree;
    }

    @NotNull
    private static Consumer<Object> configureLogging() {
        return LOGGER.isTraceEnabled() ? value -> LOGGER.trace(value.toString()) : value -> {};
    }

    private /* synthetic */ void lambda$readBindings$8(Long2ObjectSortedMap bindingCopy, Binding binding) {
        bindingCopy.put(this.pool.resolve((Object)binding.getName()), (Object)binding.getValue());
    }

    private static class LongCardinalityAwareBindingDescriptor
    extends LongObjectHashMap<BindingEntry> {
        private final transient MutableObjectLongMap<LongList> reverseMapping;
        private final transient MutableLongLongMap resultRemapping;

        public LongCardinalityAwareBindingDescriptor() {
            this(128);
        }

        LongCardinalityAwareBindingDescriptor(int initialCapacity) {
            super(initialCapacity);
            this.resultRemapping = LongLongMaps.mutable.ofInitialCapacity(initialCapacity);
            this.reverseMapping = ObjectLongMaps.mutable.ofInitialCapacity(initialCapacity);
        }

        public void put(long name, LongList varPath, boolean multiValued, String rootBindingName) {
            super.put(name, (Object)new BindingEntry(name, this.computePrevious(varPath), varPath, multiValued, rootBindingName));
            this.reverseMapping.put((Object)varPath, name);
        }

        private long computePrevious(LongList varPath) {
            if (varPath.size() == 1) {
                return 0L;
            }
            MutableLongList copy = LongLists.mutable.withInitialCapacity(varPath.size() - 1);
            for (int i = 0; i < varPath.size() - 1; ++i) {
                copy.add(varPath.get(i));
            }
            return this.getBinding((LongList)copy);
        }

        public LongList getBindingPath(long name) {
            return ((BindingEntry)this.get((long)name)).varPath;
        }

        public long getPreviousBinding(long name) {
            return ((BindingEntry)this.get((long)name)).previous;
        }

        public long getNextBinding(long bindingName, long property) {
            return ((BindingEntry)this.get((long)bindingName)).nextBindings.get(property);
        }

        public boolean isMultiValued(long name) {
            return ((BindingEntry)this.get((long)name)).multiValued;
        }

        public long getBinding(LongList bindingPath) {
            return this.reverseMapping.getIfAbsent((Object)bindingPath, 0L);
        }

        public String getBindingName(long name) {
            return ((BindingEntry)this.get((long)name)).rootBindingName;
        }

        public long remapResultPredicate(long predicate, Prefixes prefixes, EntityPool pool) {
            return this.resultRemapping.getIfAbsentPutWithKey(predicate, (LongToLongFunction & Serializable)key -> {
                String resultIri = pool.getString(key);
                String name = resultIri.substring("http://www.ontotext.com/semantic-object/result/".length());
                return pool.resolve((Object)prefixes.toIri(prefixes.nameToShortIri(name)));
            });
        }

        void computeNextBindings() {
            for (BindingEntry entry : this.values()) {
                if (entry.previous == 0L) continue;
                long lastPredicate = entry.varPath.get(entry.varPath.size() - 1);
                BindingEntry parent = (BindingEntry)this.get(entry.previous);
                long oldValue = parent.nextBindings.put(lastPredicate, entry.name);
                if (oldValue == 0L) continue;
                throw new IllegalStateException("Found other value " + oldValue + " for predicate " + lastPredicate);
            }
        }
    }

    private static class BindingEntry {
        final long name;
        final long previous;
        final LongList varPath;
        final boolean multiValued;
        final String rootBindingName;
        Long2LongMap nextBindings = new Long2LongArrayMap();

        BindingEntry(long name, long previous, LongList varPath, boolean multiValued, String rootBindingName) {
            this.name = name;
            this.previous = previous;
            this.varPath = varPath;
            this.multiValued = multiValued;
            this.rootBindingName = rootBindingName;
        }

        public LongList getPath() {
            return this.varPath;
        }
    }
}

