/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.sparql;

import com.ontotext.soaas.common.HealthResult;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.plugin.PluginsManager;
import com.ontotext.sparql.Rdf4jSparqlConnectionFactory;
import com.ontotext.sparql.RepositoryCreator;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlConnectionFactory;
import com.ontotext.sparql.SparqlEndpoint;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.repository.Repository;
import org.jetbrains.annotations.NotNull;

public class AutoLoadingSparqlConnectionFactory
implements SparqlConnectionFactory {
    private SparqlConnectionFactory delegate;

    @Override
    public SparqlConnection getConnection(SparqlEndpoint endpoint) {
        return this.getDelegate().getConnection(endpoint);
    }

    @Override
    public Repository getRepository(SparqlEndpoint endpoint) {
        return this.getDelegate().getRepository(endpoint);
    }

    @Override
    public void setRepositoryCreator(RepositoryCreator creator) {
        this.getDelegate().setRepositoryCreator(creator);
    }

    @Override
    @NotNull
    public RepositoryCreator getRepositoryCreator() {
        return this.getDelegate().getRepositoryCreator();
    }

    @Override
    public void setExclusiveRepositoryCreator(String repository, RepositoryCreator customCreator) {
        this.getDelegate().setExclusiveRepositoryCreator(repository, customCreator);
    }

    @Override
    public void reload(SparqlEndpoint endpoint) {
        this.getDelegate().reload(endpoint);
    }

    @Override
    public HealthResult checkHealth(SparqlEndpoint endpoint) {
        return this.getDelegate().checkHealth(endpoint);
    }

    @Override
    public synchronized void close() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.close();
        this.delegate = null;
    }

    private SparqlConnectionFactory getDelegate() {
        if (this.delegate == null) {
            List factories = PluginsManager.loadPlugins(SparqlConnectionFactory.class);
            if (factories.isEmpty()) {
                factories.add(new Rdf4jSparqlConnectionFactory());
            } else {
                factories.removeIf(factory -> factory instanceof AutoLoadingSparqlConnectionFactory);
            }
            if (factories.size() != 1) {
                String factoryList = factories.stream().map(factory -> factory.getClass().getName()).collect(Collectors.joining(", "));
                Loggers.sparqlLogger().warn("Found multiple SPARQL connection factories {} Using first.", (Object)factoryList);
            }
            this.delegate = (SparqlConnectionFactory)factories.get(0);
            Loggers.sparqlLogger().info("Loaded connection factory implementation {}", this.delegate.getClass());
        }
        return this.delegate;
    }
}

