/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.repository.http;

import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import org.apache.http.HttpConnection;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RetryHandlerStale
implements HttpRequestRetryHandler {
    private final Logger logger = LoggerFactory.getLogger(RetryHandlerStale.class);

    RetryHandlerStale() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retryRequest(IOException ioe, int count, HttpContext context) {
        if (ioe instanceof NoHttpResponseException || ioe instanceof HttpHostConnectException || ioe instanceof NoRouteToHostException || ioe instanceof UnknownHostException) {
            return false;
        }
        if (count > 1) {
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
        HttpConnection conn = clientContext.getConnection();
        RetryHandlerStale retryHandlerStale = this;
        synchronized (retryHandlerStale) {
            if (conn.isStale()) {
                try {
                    this.logger.warn("Closing stale connection");
                    conn.close();
                    return true;
                }
                catch (IOException ioe2) {
                    this.logger.error("Error closing stale connection", (Throwable)ioe2);
                }
            }
        }
        return false;
    }
}

