/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.repository.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Range;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class PlatformServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final Collection<Range<Integer>> httpCodes;
    private final int maxRetries;
    private final long retryInterval;

    public PlatformServiceUnavailableRetryStrategy(int maxRetries, int retryInterval, Collection<Range<Integer>> httpCodes) {
        this.maxRetries = Args.positive((int)maxRetries, (String)"Max retries");
        this.retryInterval = Args.positive((int)retryInterval, (String)"Retry interval");
        this.httpCodes = httpCodes == null || httpCodes.isEmpty() ? Collections.singletonList(Range.is((Comparable)Integer.valueOf(503))) : new ArrayList<Range<Integer>>(httpCodes);
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        if (executionCount <= this.maxRetries) {
            int statusCode = response.getStatusLine().getStatusCode();
            return this.httpCodes.stream().anyMatch(range -> range.contains((Object)statusCode));
        }
        return false;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }
}

