/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.repository.http;

import com.ontotext.repository.http.OperationInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;

public class InterceptingRepositoryConnection
implements RepositoryConnection {
    private final RepositoryConnection delegate;
    private final Set<OperationInterceptor> queryInterceptors = new CopyOnWriteArraySet<OperationInterceptor>();
    private final Set<OperationInterceptor> updateInterceptors = new CopyOnWriteArraySet<OperationInterceptor>();
    private boolean queryActive = false;
    private boolean updateActive = false;

    public InterceptingRepositoryConnection(RepositoryConnection delegate) {
        this.delegate = delegate;
    }

    public Repository getRepository() {
        return this.delegate.getRepository();
    }

    public void setParserConfig(ParserConfig config) {
        this.delegate.setParserConfig(config);
    }

    public ParserConfig getParserConfig() {
        return this.delegate.getParserConfig();
    }

    public ValueFactory getValueFactory() {
        return this.delegate.getValueFactory();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public Query prepareQuery(QueryLanguage ql, String query) {
        return this.prepareQuery(ql, query, null);
    }

    public Query prepareQuery(QueryLanguage ql, String query, String baseUri) {
        this.interceptQuery();
        return this.delegate.prepareQuery(ql, query, baseUri);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) {
        return this.prepareTupleQuery(ql, query, null);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseUri) {
        this.interceptQuery();
        return this.delegate.prepareTupleQuery(ql, query, baseUri);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) {
        return this.prepareGraphQuery(ql, query, null);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseUri) {
        this.interceptQuery();
        return this.delegate.prepareGraphQuery(ql, query, baseUri);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) {
        return this.prepareBooleanQuery(ql, query, null);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseUri) {
        this.interceptQuery();
        return this.delegate.prepareBooleanQuery(ql, query, baseUri);
    }

    public Update prepareUpdate(QueryLanguage ql, String update) {
        return this.prepareUpdate(ql, update, null);
    }

    public Update prepareUpdate(QueryLanguage ql, String update, String baseUri) {
        this.interceptUpdate();
        return this.delegate.prepareUpdate(ql, update, baseUri);
    }

    public RepositoryResult<Resource> getContextIDs() {
        return this.delegate.getContextIDs();
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) {
        return this.delegate.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) {
        return this.delegate.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) {
        return this.delegate.hasStatement(st, includeInferred, contexts);
    }

    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) {
        this.delegate.exportStatements(subj, pred, obj, includeInferred, handler, contexts);
    }

    public void export(RDFHandler handler, Resource ... contexts) {
        this.delegate.export(handler, contexts);
    }

    public long size(Resource ... contexts) {
        return this.delegate.size(contexts);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Deprecated
    public void setAutoCommit(boolean autoCommit) {
        this.delegate.setAutoCommit(autoCommit);
    }

    @Deprecated
    public boolean isAutoCommit() {
        return this.delegate.isAutoCommit();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public void setIsolationLevel(IsolationLevel level) {
        this.delegate.setIsolationLevel(level);
    }

    public IsolationLevel getIsolationLevel() {
        return this.delegate.getIsolationLevel();
    }

    public void begin() {
        this.delegate.begin();
    }

    public void begin(IsolationLevel level) {
        this.delegate.begin(level);
    }

    public void begin(TransactionSetting ... settings) {
        this.delegate.begin(settings);
    }

    public void commit() {
        this.delegate.commit();
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void add(InputStream in, String baseUri, RDFFormat dataFormat, Resource ... contexts) throws IOException {
        this.delegate.add(in, baseUri, dataFormat, contexts);
    }

    public void add(Reader reader, String baseUri, RDFFormat dataFormat, Resource ... contexts) throws IOException {
        this.delegate.add(reader, baseUri, dataFormat, contexts);
    }

    public void add(URL url, String baseUri, RDFFormat dataFormat, Resource ... contexts) throws IOException {
        this.delegate.add(url, baseUri, dataFormat, contexts);
    }

    public void add(File file, String baseUri, RDFFormat dataFormat, Resource ... contexts) throws IOException {
        this.delegate.add(file, baseUri, dataFormat, contexts);
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) {
        this.delegate.add(subject, predicate, object, contexts);
    }

    public void add(Statement st, Resource ... contexts) {
        this.delegate.add(st, contexts);
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) {
        this.delegate.add(statements, contexts);
    }

    public void add(CloseableIteration<? extends Statement> closeableIteration, Resource ... resources) throws RepositoryException {
        this.delegate.add(closeableIteration, resources);
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) {
        this.delegate.remove(subject, predicate, object, contexts);
    }

    public void remove(Statement st, Resource ... contexts) {
        this.delegate.remove(st, contexts);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) {
        this.delegate.remove(statements, contexts);
    }

    public void remove(CloseableIteration<? extends Statement> closeableIteration, Resource ... resources) throws RepositoryException {
        this.delegate.remove(closeableIteration, resources);
    }

    public void clear(Resource ... contexts) {
        this.delegate.clear(contexts);
    }

    public RepositoryResult<Namespace> getNamespaces() {
        return this.delegate.getNamespaces();
    }

    public String getNamespace(String prefix) {
        return this.delegate.getNamespace(prefix);
    }

    public void setNamespace(String prefix, String name) {
        this.delegate.setNamespace(prefix, name);
    }

    public void removeNamespace(String prefix) {
        this.delegate.removeNamespace(prefix);
    }

    public void clearNamespaces() {
        this.delegate.clearNamespaces();
    }

    void interceptQuery() {
        if (this.queryActive) {
            for (OperationInterceptor interceptor : this.queryInterceptors) {
                interceptor.intercept(this.delegate);
            }
        }
    }

    void interceptUpdate() {
        if (this.updateActive) {
            for (OperationInterceptor interceptor : this.updateInterceptors) {
                interceptor.intercept(this.delegate);
            }
        }
    }

    public void addQueryInterceptor(OperationInterceptor interceptor) {
        this.queryInterceptors.add(interceptor);
        this.queryActive = true;
    }

    public void removeQueryInterceptor(OperationInterceptor interceptor) {
        this.queryInterceptors.remove(interceptor);
        this.queryActive = !this.queryInterceptors.isEmpty();
    }

    public void addUpdateInterceptor(OperationInterceptor interceptor) {
        this.updateInterceptors.add(interceptor);
        this.updateActive = true;
    }

    public void removeUpdateInterceptor(OperationInterceptor interceptor) {
        this.updateInterceptors.remove(interceptor);
        this.updateActive = !this.updateInterceptors.isEmpty();
    }

    public void close() {
        this.delegate.close();
    }
}

